/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.impl.ByteArrayAccessStrategy;
import com.hazelcast.internal.memory.impl.EndiannessUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.tstore.hybridlog.HybridLogDirectAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.UnguardedHybridLogDirectAccessor;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.record.BaseTieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.GuardedTieredStoreRecordAccessor;

public class UnguardedTieredStoreRecordAccessor
extends BaseTieredStoreRecordAccessor {
    private final HybridLogDirectAccessor directAccessor = new UnguardedHybridLogDirectAccessor();

    public UnguardedTieredStoreRecordAccessor(EnterpriseSerializationService ss, MapContainer mapContainer, int partitionId) {
        super(ss, mapContainer, partitionId);
    }

    @Override
    protected HybridLogDirectAccessor directAccessor() {
        return this.directAccessor;
    }

    public static long readKeyAddress(long recordVAddress) {
        return BaseTieredStoreRecordAccessor.readKeyAddress(recordVAddress);
    }

    public static long getNextRecordAddress(byte[] record) {
        long header = EndiannessUtil.readLong(ByteArrayAccessStrategy.INSTANCE, record, 0L, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        return header & 0x3FFFFFFFFFFFFFFFL;
    }

    public static long keyHash64(byte[] record) {
        int keyLen = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, record, 12L, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        return HashUtil.MurmurHash3_x64_64(record, 24, keyLen -= 8);
    }

    public static boolean keyEquals(byte[] record, Data key) {
        int keyLen = key.dataSize();
        int recordKeyLen = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, record, 12L, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        if (keyLen != (recordKeyLen -= 8)) {
            return false;
        }
        int recordKeyOffset = 24;
        if (key instanceof HeapData) {
            byte[] keyBytes = key.toByteArray();
            int keyOffset = 8;
            for (int i = 0; i < keyLen; ++i) {
                if (keyBytes[keyOffset + i] == record[recordKeyOffset + i]) continue;
                return false;
            }
        } else {
            assert (key instanceof NativeMemoryData);
            long keyAddress = ((NativeMemoryData)key).address();
            long keyOffset = keyAddress + 12L;
            for (int i = 0; i < keyLen; ++i) {
                if (GlobalMemoryAccessorRegistry.MEM.getByte(keyOffset + (long)i) == record[recordKeyOffset + i]) continue;
                return false;
            }
        }
        return true;
    }

    public static UnguardedTieredStoreRecordAccessor unguard(GuardedTieredStoreRecordAccessor guardedAccessor) {
        return new UnguardedTieredStoreRecordAccessor(guardedAccessor.ss, guardedAccessor.mapContainer, guardedAccessor.partitionId);
    }
}

