/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.subscriber.AbstractQueryCacheEndToEndConstructor;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.map.impl.querycache.subscriber.operation.MadePublishableOperation;
import com.hazelcast.map.impl.querycache.subscriber.operation.PublisherCreateOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class NodeQueryCacheEndToEndConstructor
extends AbstractQueryCacheEndToEndConstructor {
    public NodeQueryCacheEndToEndConstructor(QueryCacheRequest request) {
        super(request);
    }

    @Override
    public void createPublisherAccumulator(AccumulatorInfo info, boolean urgent) {
        Collection<QueryResult> results = this.createPublishersAndGetQueryResults(info);
        if (!CollectionUtil.isEmpty(results)) {
            NodeQueryCacheEndToEndConstructor.prepopulate(this.queryCache, results);
        }
        boolean populate = info.isPopulate();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Pre population is %s", populate ? "enabled" : "disabled");
        }
        if (populate) {
            this.madePublishable(info.getMapName(), info.getCacheId());
        }
    }

    private Collection<QueryResult> createPublishersAndGetQueryResults(AccumulatorInfo info) {
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        Collection<Member> members = this.context.getMemberList();
        ArrayList futures = new ArrayList(members.size());
        for (Member member : members) {
            Future future = invokerWrapper.invokeOnTarget(new PublisherCreateOperation(info), member);
            futures.add(future);
        }
        return FutureUtil.returnWithDeadline(futures, 5L, TimeUnit.MINUTES);
    }

    private void madePublishable(String mapName, String cacheId) {
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        Collection<Member> memberList = this.context.getMemberList();
        ArrayList<Future> futures = new ArrayList<Future>(memberList.size());
        for (Member member : memberList) {
            MadePublishableOperation operation = new MadePublishableOperation(mapName, cacheId);
            Future future = invokerWrapper.invokeOnTarget(operation, member);
            futures.add(future);
        }
        FutureUtil.waitWithDeadline(futures, 5L, TimeUnit.MINUTES);
    }

    private static void prepopulate(InternalQueryCache queryCache, Collection<QueryResult> resultSets) {
        for (QueryResult queryResult : resultSets) {
            try {
                if (queryResult == null || queryResult.isEmpty()) continue;
                if (queryCache.reachedMaxCapacity()) break;
                queryCache.prepopulate(queryResult.iterator());
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }
}

