/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.merkletree.ComparisonResult;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.EnterpriseMapMigrationAwareService;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MerkleTreeDiffIterator;
import com.hazelcast.map.impl.operation.EnterpriseMapChunkContext;
import com.hazelcast.map.impl.operation.EnterpriseMapDataSerializerHook;
import com.hazelcast.map.impl.operation.MapChunk;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.Predicate;

public class EnterpriseMapChunk
extends MapChunk {
    int[] merkleTreeDiff;
    private transient ComparisonResult comparisonResult;

    public EnterpriseMapChunk() {
    }

    public EnterpriseMapChunk(EnterpriseMapChunkContext context, int chunkNumber, Predicate isEndOfChunk) {
        super(context, chunkNumber, isEndOfChunk);
        this.merkleTreeDiff = context.getMerkleTreeDiff();
        this.comparisonResult = ComparisonResult.of(this.merkleTreeDiff);
    }

    @Override
    public void beforeRun() {
        super.beforeRun();
        RecordStore recordStore = this.getRecordStore(this.mapName);
        ArrayList<Object> mapNameFuturePairs = new ArrayList<Object>();
        EnterpriseMapMigrationAwareService.requestCompactorsToStop(recordStore, mapNameFuturePairs);
        EnterpriseMapMigrationAwareService.waitForCompactorsToStop(recordStore.getPartitionId(), mapNameFuturePairs, this.logger);
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        RecordStore recordStore = this.getRecordStore(this.mapName);
        EnterpriseMapMigrationAwareService.setCompactorsBackToRunning(recordStore);
    }

    @Override
    protected void incrementReplicationCount() {
        if (this.comparisonResult == ComparisonResult.FULL_SYNC_REQUIRED) {
            super.incrementReplicationCount();
        } else {
            this.context.getMapStats().getReplicationStats().incrementDiffPartitionReplicationCount();
        }
    }

    @Override
    protected void incrementReplicationRecordCount(long delta) {
        if (this.comparisonResult == ComparisonResult.FULL_SYNC_REQUIRED) {
            super.incrementReplicationRecordCount(delta);
        } else {
            this.context.getMapStats().getReplicationStats().incrementDiffPartitionReplicationRecordsCount(delta);
        }
    }

    @Override
    protected void initializeRecordStore(String mapName, RecordStore recordStore) {
        this.logger = this.getLogger();
        if (this.comparisonResult == ComparisonResult.FULL_SYNC_REQUIRED) {
            super.initializeRecordStore(mapName, recordStore);
            return;
        }
        if (this.comparisonResult == ComparisonResult.NO_SYNC_REQUIRED) {
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Applying differential sync for %s", mapName);
        }
        MapContainer mapContainer = recordStore.getMapContainer();
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapContainer.getMapServiceContext().getPartitionContainer(this.getPartitionId());
        MerkleTree merkleTree = partitionContainer.getMerkleTreeOrNull(mapContainer);
        assert (merkleTree != null) : "MerkleTree was unexpectedly null";
        MerkleTreeDiffIterator merkleTreeDiffIterator = new MerkleTreeDiffIterator(recordStore.iterator(), this.merkleTreeDiff);
        LinkedList forRemoval = new LinkedList();
        boolean backup = this.getReplicaIndex() != 0;
        merkleTreeDiffIterator.forEachRemaining(e -> forRemoval.add((Data)e.getKey()));
        forRemoval.forEach(key -> recordStore.removeReplicatedRecord((Data)key, backup));
    }

    @Override
    protected void writeMetadata(ObjectDataOutput out) throws IOException {
        super.writeMetadata(out);
        out.writeIntArray(this.merkleTreeDiff);
    }

    @Override
    protected void readMetadata(ObjectDataInput in) throws IOException {
        super.readMetadata(in);
        this.merkleTreeDiff = in.readIntArray();
        this.comparisonResult = ComparisonResult.of(this.merkleTreeDiff);
    }

    @Override
    public int getFactoryId() {
        return EnterpriseMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }
}

