/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.shaded.com.fasterxml.jackson.core.JacksonException;
import com.hazelcast.license.shaded.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.license.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.hazelcast.license.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.hazelcast.license.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.hazelcast.license.shaded.com.fasterxml.jackson.databind.json.JsonMapper;
import com.hazelcast.license.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import com.hazelcast.license.shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.NamedParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public final class LicenseExtractorV7 {
    private static final byte[] a = "MCowBQYDK2VwAyEAtfgGX-hKCwfmnq7Mbh4gUsRtiMyXFCdC5I3wWtyClFE=".getBytes(StandardCharsets.UTF_8);
    private static final JsonMapper b = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).addModule(new JavaTimeModule())).addModule(new SimpleModule("LicenseDeserializationModule").addDeserializer(Feature.class, new a(Feature.class)))).build();

    private LicenseExtractorV7() {
    }

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        boolean bl;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new InvalidLicenseException("License key can not be empty.");
        }
        Object object = licenseKey.split("#");
        object = object[((String[])object).length - 1];
        if (((String[])(object = object.split("\\."))).length < 2) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        Object object2 = object[((String[])object).length - 2];
        object = object[((String[])object).length - 1];
        object2 = Base64.getUrlDecoder().decode((String)object2);
        object = Base64.getUrlDecoder().decode((String)object);
        try {
            Object object3 = Base64.getUrlDecoder().decode(a);
            object3 = new X509EncodedKeySpec((byte[])object3);
            object3 = KeyFactory.getInstance(NamedParameterSpec.ED25519.getName()).generatePublic((KeySpec)object3);
            Signature signature = Signature.getInstance(NamedParameterSpec.ED25519.getName());
            signature.initVerify((PublicKey)object3);
            signature.update((byte[])object2);
            bl = signature.verify((byte[])object);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException generalSecurityException) {
            throw new InvalidLicenseException("Invalid License Key! Couldn't verify license signature", generalSecurityException);
        }
        if (!bl) {
            throw new InvalidLicenseException("Invalid License Key! Signature is not valid");
        }
        try {
            String string;
            return b.readValue((byte[])object2, License.class).toBuilder().key(string).build();
        }
        catch (IOException iOException) {
            throw new InvalidLicenseException("Invalid License Key! Couldn't parse license JSON", iOException);
        }
    }

    private static final class a
    extends StdDeserializer<Feature> {
        protected a(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public final /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
            return Feature.getFeature(jsonParser.readValueAs(Integer.class));
        }
    }
}

