/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.ExtractorUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.EnumSet;

public final class LicenseExtractorV6 {
    public static final int RESERVED = 52;
    public static final char[] CHARS = "\u00ea$\u00e8\u0107\u0106/<~|r\u00ff\u0178[>@{`\u00a3-)\u00e9_}\u010d:%]!*+=(&?.\u00e7;\u017aeToS^\u00fc\u00dc\u017e\u017cxml9nVO2CpEBYhLfavKPkijqGd5W0871ZgXusMJ3cUDz6ytHNIRA4FQwb".toCharArray();
    public static final int LENGTH = CHARS.length;

    private LicenseExtractorV6() {
    }

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        String string;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new InvalidLicenseException("License key can not be empty.");
        }
        Object[] objectArray = licenseKey.split("#");
        if (LENGTH != (objectArray = (Object[])objectArray[objectArray.length - 1].toCharArray()).length) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        char[] cArray = new char[LENGTH];
        System.arraycopy(objectArray, 0, cArray, 0, LENGTH);
        int n = cArray[51];
        cArray[51] = '\u0000';
        int n2 = cArray[52];
        cArray[52] = '\u0000';
        char[] cArray2 = ExtractorUtils.hash(cArray);
        if (cArray2[0] != n || cArray2[cArray2.length - 1] != n2) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        n = cArray[0];
        int n3 = n;
        n = cArray[LicenseExtractorV6.a(CHARS, (char)n3)] == '1' ? 1 : 0;
        n3 = n2 = cArray[1];
        char cfr_ignored_0 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n2 = cArray[2];
        int n4 = cArray[3];
        n3 = n2;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n5 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = n4;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n2 = n5 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        n4 = cArray[4];
        int n6 = cArray[5];
        n3 = n4;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n7 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = n6;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n4 = n7 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        n6 = cArray[6];
        int n8 = cArray[7];
        n3 = n6;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n9 = 2000 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = n8;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n6 = n9 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        ZonedDateTime zonedDateTime = LocalDate.of(n6, n4, n2).atTime(LocalTime.MAX).atZone(ZoneOffset.UTC);
        n4 = cArray[8];
        n6 = cArray[9];
        n8 = cArray[10];
        int n10 = cArray[11];
        n3 = n4;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n11 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 1000;
        n3 = n6;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n12 = n11 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 100;
        n3 = n8;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n13 = n12 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = n10;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n4 = n13 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        n6 = cArray[12];
        n8 = cArray[13];
        n10 = cArray[14];
        int n14 = cArray[15];
        n3 = n6;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) == 1) {
            n3 = n8;
            n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
            int n15 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 100;
            n3 = n10;
            n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
            int n16 = n15 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
            n3 = n14;
            n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
            n6 = n16 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        } else {
            n3 = n8;
            n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
            int n17 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
            n3 = n10;
            n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
            n6 = n17 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        }
        n3 = n8 = cArray[16];
        n8 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)] == '1' ? 1 : 0;
        n10 = cArray[17];
        n14 = cArray[18];
        n3 = n10;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n18 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = n14;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n10 = n18 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        n14 = cArray[19];
        int n19 = cArray[20];
        n3 = n14;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n20 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = n19;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n14 = n20 + LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        ZonedDateTime zonedDateTime2 = zonedDateTime.minusMonths(n14);
        n3 = cArray[21];
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n19 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10000;
        n3 = cArray[22];
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n21 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 1000;
        n3 = cArray[23];
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n22 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 100;
        n3 = cArray[24];
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n23 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = cArray[25];
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n24 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        n19 = n19 + n21 + n22 + n23 + n24;
        n3 = cArray[26];
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n21 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = cArray[27];
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        n22 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3);
        n21 += n22;
        n22 = cArray[28];
        n23 = cArray[29];
        n24 = cArray[30];
        int n25 = cArray[31];
        int n26 = cArray[32];
        int n27 = cArray[33];
        int n28 = cArray[34];
        int n29 = cArray[35];
        int n30 = cArray[36];
        int n31 = cArray[37];
        int n32 = cArray[38];
        int n33 = cArray[39];
        int n34 = cArray[40];
        int n35 = cArray[41];
        int n36 = cArray[42];
        int n37 = cArray[43];
        int n38 = cArray[44];
        int n39 = cArray[45];
        int n40 = cArray[46];
        char cfr_ignored_1 = cArray[47];
        char cfr_ignored_2 = cArray[48];
        char cfr_ignored_3 = cArray[49];
        char cfr_ignored_4 = cArray[50];
        EnumSet<Feature> enumSet = EnumSet.noneOf(Feature.class);
        if (n21 > 0) {
            enumSet.add(Feature.TPC);
        }
        n3 = n22;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.MAN_CENTER);
            enumSet.add(Feature.STREAMING_MAN_CENTER);
        }
        n3 = n23;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.CLUSTERED_JMX);
        }
        n3 = n24;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.CLUSTERED_REST);
        }
        n3 = n25;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.SECURITY);
        }
        n3 = n26;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.WAN);
        }
        n3 = n27;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.HD_MEMORY);
        }
        n3 = n28;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.PERSISTENCE);
            enumSet.add(Feature.STREAMING_LOSSLESS_CLUSTER_RESTART);
        }
        n3 = n29;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.ROLLING_UPGRADE);
        }
        n3 = n30;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.STREAMING_JOB_UPGRADES);
        }
        n3 = n31;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.CLIENT_FILTERING);
        }
        n3 = n32;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.CP_PERSISTENCE);
        }
        n3 = n33;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.DYNAMIC_CONFIGURATION);
        }
        n3 = n34;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.TIERED_STORAGE);
        }
        n3 = n35;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.ADVANCED_CP);
        }
        n3 = n36;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.FLOW);
        }
        n3 = n37;
        if (LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)])) == 1) {
            enumSet.add(Feature.KONG_CONNECTOR);
        }
        n3 = n38;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n41 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 100;
        n3 = n39;
        n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)];
        int n42 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)n3) * 10;
        n3 = n40;
        int n43 = LicenseExtractorV6.a(ExtractorUtils.DIGITS, (char)(n3 = cArray[LicenseExtractorV6.a(CHARS, (char)n3)]));
        int n44 = n41 + n42 + n43;
        n44 = n44 == 0 ? 100 : n44;
        return License.builder().version(LicenseVersion.V6).key(string).creationDate(zonedDateTime2).expiryDate(zonedDateTime).allowedNumberOfNodes(n4).allowedNativeMemorySize(n44).allowedTpcCores(n21).hazelcastVersion(n6).trial(n != 0).oem(n8 != 0).gracePeriod(n10).features(enumSet).allowedTieredStoreSize(n19).build();
    }

    private static int a(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }
}

