/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.security.permission.ConnectorPermission;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import javax.annotation.Nonnull;

public final class StreamUDPSocketP<T>
extends AbstractProcessor {
    private static final int BUFFER_SIZE = 65507;
    private final String host;
    private final int port;
    private final Integer receiveBufferSize;
    private final BiFunctionEx<byte[], SocketAddress, T> projectionFn;
    private final String networkInterface;
    private final StandardProtocolFamily protocolFamily;
    private DatagramChannel datagramChannel;
    private MembershipKey membershipKey;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(65507);
    private T pending;

    public StreamUDPSocketP(String host, int port, Integer receiveBufferSize, String networkInterface, StandardProtocolFamily protocolFamily, @Nonnull BiFunctionEx<byte[], SocketAddress, T> projectionFn) {
        this.host = Preconditions.isNotNull(host, "host");
        this.port = Preconditions.isNotNull(port, "port");
        this.networkInterface = networkInterface;
        this.protocolFamily = Preconditions.isNotNull(protocolFamily, "protocolFamily");
        this.receiveBufferSize = receiveBufferSize;
        this.projectionFn = Preconditions.isNotNull(projectionFn, "projectionFn");
    }

    @Override
    protected void init(@Nonnull Processor.Context context) throws Exception {
        InetAddress hostAddress = InetAddress.getByName(this.host);
        this.datagramChannel = DatagramChannel.open(this.protocolFamily);
        if (this.receiveBufferSize != null) {
            this.datagramChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, this.receiveBufferSize);
        }
        this.datagramChannel.bind(new InetSocketAddress(this.port));
        if (hostAddress.isMulticastAddress()) {
            this.membershipKey = this.datagramChannel.join(hostAddress, NetworkInterface.getByName(this.networkInterface));
        }
        this.datagramChannel.configureBlocking(false);
        this.byteBuffer.limit(0);
    }

    @Override
    public boolean complete() {
        try {
            return this.tryComplete();
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    private boolean tryComplete() throws IOException {
        this.fillBuffer();
        this.emitFromBuffer();
        return false;
    }

    private void fillBuffer() throws IOException {
        if (this.pending != null) {
            return;
        }
        this.byteBuffer.clear();
        SocketAddress senderAddress = this.datagramChannel.receive(this.byteBuffer);
        if (senderAddress != null) {
            this.byteBuffer.flip();
            byte[] data = new byte[this.byteBuffer.remaining()];
            this.byteBuffer.get(data);
            this.pending = this.projectionFn.apply(data, senderAddress);
        }
    }

    private void emitFromBuffer() {
        if (this.pending != null && this.tryEmit(this.pending)) {
            this.pending = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.membershipKey != null) {
            this.getLogger().info("Closing membership key " + this.hostAndPort());
            this.membershipKey.drop();
        }
        if (this.datagramChannel != null) {
            this.getLogger().info("Closing channel " + this.hostAndPort());
            this.datagramChannel.close();
        }
    }

    private String hostAndPort() {
        return this.host + ":" + this.port;
    }

    public static <T> ProcessorMetaSupplier streamUDP(String host, int port, Integer receiveBufferSize, String networkInterface, StandardProtocolFamily protocolFamily, @Nonnull BiFunctionEx<byte[], SocketAddress, T> projectionFn) {
        return ProcessorMetaSupplier.forceTotalParallelismOne(ProcessorSupplier.of(() -> new StreamUDPSocketP(host, port, receiveBufferSize, networkInterface, protocolFamily, projectionFn)), ConnectorPermission.socket(host, port, "read"));
    }
}

