/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.TStoreException;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImplMetrics;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogMessagePrologueFunction;
import com.hazelcast.internal.tstore.hybridlog.impl.PageConsumer;
import com.hazelcast.internal.tstore.hybridlog.impl.PageHeaderSupport;
import com.hazelcast.internal.tstore.hybridlog.impl.Pager;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

class HybridLogSlotAllocator {
    private static final AtomicLongFieldUpdater<HybridLogSlotAllocator> CURRENT_TAIL_OFFSET_UPDATER = AtomicLongFieldUpdater.newUpdater(HybridLogSlotAllocator.class, "currentTailPageAndOffset");
    final Pager pager;
    private final ILogger logger = Logger.getLogger(HybridLogSlotAllocator.class);
    private final HybridLogMessagePrologueFunction logPrologueFn;
    private final PageConsumer pagePreparatorFn;
    private final HybridLogImplMetrics metrics;
    private final int maxSupportedRecordSizeInBytes;
    private final boolean finestEnabled = this.logger.isFinestEnabled();
    private volatile long currentTailPageAndOffset;

    HybridLogSlotAllocator(HybridLogMessagePrologueFunction logPrologueFn, Pager pager, PageConsumer pagePreparatorFn, long initLogicalAddress, HybridLogImplMetrics metrics) {
        this.logPrologueFn = logPrologueFn;
        this.pagePreparatorFn = pagePreparatorFn;
        this.metrics = metrics;
        Preconditions.checkTrue(QuickMath.isPowerOfTwo(pager.pageSize), "Page size must be a power of two");
        this.pager = pager;
        this.maxSupportedRecordSizeInBytes = pager.pageSize - 8;
        int page = pager.pageOf(initLogicalAddress);
        int offset = pager.offsetOf(initLogicalAddress);
        if (offset != 0) {
            ++page;
            offset = 8;
        } else {
            offset = 8;
        }
        this.currentTailPageAndOffset = this.pack(page, offset);
        int initPage = this.page(this.currentTailPageAndOffset);
        if (!pager.preparePage(initPage)) {
            throw new IllegalStateException(logPrologueFn.prologue() + " - Unable to allocate initial page");
        }
    }

    public int getMaxSupportedRecordSizeInBytes() {
        return this.maxSupportedRecordSizeInBytes;
    }

    long tryAllocate(int size) throws TStoreException {
        if (size > this.maxSupportedRecordSizeInBytes) {
            throw new TStoreException(this.logPrologueFn.prologue() + " - The requested size is bigger than the maximum size " + this.pager.pageSize + " bytes");
        }
        if (size <= 0) {
            throw new TStoreException(this.logPrologueFn.prologue() + "The requested size to allocate is invalid. Requested to allocate " + size + " bytes");
        }
        long pageAndOffset = this.currentTailPageAndOffset;
        if (this.offset(pageAndOffset) > this.pager.pageSize) {
            if (this.shouldWaitForPageFlush(this.page(this.currentTailPageAndOffset) + 1)) {
                return -2L;
            }
            return -1L;
        }
        int paddedSize = TStoreUtil.padTo8Bytes(size);
        long newAddr = CURRENT_TAIL_OFFSET_UPDATER.addAndGet(this, paddedSize);
        int tailOffset = this.offset(newAddr);
        int page = this.page(newAddr);
        int tailPage = page++;
        int offset = tailOffset - paddedSize;
        if (offset > this.pager.pageSize) {
            if (this.shouldWaitForPageFlush(page)) {
                return -2L;
            }
            return -1L;
        }
        try {
            if (tailOffset > this.pager.pageSize) {
                if (this.finestEnabled && page > this.page(pageAndOffset)) {
                    this.logger.finest(this.logPrologueFn.prologue() + " - Moving to " + this.pager.prettyFormatPage(page, this.pager.pageMetadata(page)) + " with the allocation");
                }
                this.pagePreparatorFn.accept(page);
                if (!this.pager.preparePage(page)) {
                    if (this.shouldWaitForPageFlush(page)) {
                        long newTailPageAndOffset = this.pack(tailPage, this.pager.pageSize);
                        CURRENT_TAIL_OFFSET_UPDATER.set(this, newTailPageAndOffset);
                        return -2L;
                    }
                    long newTailPageAndOffset = this.pack(tailPage, this.pager.pageSize);
                    CURRENT_TAIL_OFFSET_UPDATER.set(this, newTailPageAndOffset);
                    return -1L;
                }
                CURRENT_TAIL_OFFSET_UPDATER.set(this, this.pack(page, paddedSize + 8));
                offset = 8;
                int wastedBytesOnPaging = this.pager.pageSize - this.offset(pageAndOffset);
                this.metrics.onPaging(page, wastedBytesOnPaging);
            }
            long logicalAddress = this.pager.asLogicalAddress(page, offset);
            long pageHeadAddress = this.pager.pageAddress(page);
            assert (this.pager.verifyAccess(page, pageHeadAddress));
            PageHeaderSupport.updateHighestAllocation(pageHeadAddress, offset);
            if (this.finestEnabled) {
                this.logger.finest(this.logPrologueFn.prologue() + " - Slot allocated at " + this.pager.prettyFormat(logicalAddress) + " with size " + size + " padded to" + paddedSize);
            }
            this.zeroBlock(logicalAddress, paddedSize);
            this.metrics.onAllocation(size, paddedSize);
            return logicalAddress;
        }
        catch (Throwable throwable) {
            CURRENT_TAIL_OFFSET_UPDATER.set(this, this.pack(tailPage, this.pager.pageSize));
            throw throwable;
        }
    }

    int getBumpedTailPage() {
        long pageAndOffset = this.currentTailPageAndOffset;
        int offset = this.offset(pageAndOffset);
        if (offset == 8) {
            return this.page(pageAndOffset);
        }
        return this.page(pageAndOffset) + 1;
    }

    private void zeroBlock(long logicalAddress, int size) {
        long physicalAddress = this.pager.asPhysicalAddress(logicalAddress);
        TStoreUtil.zeroBlock(physicalAddress, size);
    }

    private boolean shouldWaitForPageFlush(int page) {
        boolean shouldWait;
        boolean bl = shouldWait = page >= this.pager.totalPages + this.pager.flushedUntilPage;
        if (shouldWait && this.finestEnabled) {
            this.logger.finest(this.logPrologueFn.prologue() + " - " + this.pager.prettyFormatPage(page, this.pager.pageMetadata(page)) + " is not ready yet, the allocator has to back off.");
        }
        return shouldWait;
    }

    private int page(long pageAndOffset) {
        return (int)(pageAndOffset >> 32);
    }

    private int offset(long pageAndOffset) {
        return (int)(pageAndOffset & 0xFFFFFFFFL);
    }

    private long pack(int page, int offset) {
        return (long)page << 32 | (long)offset;
    }

    String debugInfo() {
        return "\n" + "\t" + " - Initial logical address: " + this.pager.prettyFormat(this.pager.asLogicalAddress(this.page(this.currentTailPageAndOffset), this.offset(this.currentTailPageAndOffset))) + '\n' + "\t" + " - Initial tail technical address: 0x0" + Long.toHexString(this.currentTailPageAndOffset) + '\n' + "\t";
    }
}

