/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SegmentLock {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    void pinForRead() {
        this.lock.readLock().lock();
    }

    void pinForUpdate() {
        this.lock.writeLock().lock();
    }

    void unpin() {
        assert (this.lock.isWriteLockedByCurrentThread() || this.lock.getReadHoldCount() > 0);
        boolean pinnedForUpdate = this.lock.isWriteLockedByCurrentThread();
        if (pinnedForUpdate) {
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return String.format("SegmentLock pinned for Read: %d, pinned for Update: %d", this.lock.getReadLockCount(), this.lock.isWriteLocked() ? 1 : 0);
    }
}

