/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.compaction.InterruptableCompactor;
import com.hazelcast.internal.tstore.compaction.PartitionCompactorStateManager;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class LogBasedCompactor<T>
extends InterruptableCompactor<T> {
    public static final long DEFAULT_SCAN_TIMEOUT_MILLIS = 10L;
    public static final HazelcastProperty SCAN_TIMEOUT_MILLIS = new HazelcastProperty("hazelcast.tiered.store.partition.compactor.scan.timeout.millis", 10L, TimeUnit.MILLISECONDS);
    protected final int segmentNo;
    protected final long createdAt;
    private final long compactorScanTimeoutNanos;
    private final HybridLogImpl hybridLog;
    private final AtomicBoolean triggeredDeletion;
    private final PartitionCompactorStateManager compactorStateManager;
    private int lastVisitedRecordCount;

    public LogBasedCompactor(HybridLogImpl hybridLog, int segmentNo, HazelcastProperties properties) {
        super(hybridLog.getDevice());
        this.createdAt = System.nanoTime();
        this.hybridLog = hybridLog;
        this.segmentNo = segmentNo;
        this.compactorStateManager = new PartitionCompactorStateManager();
        this.triggeredDeletion = new AtomicBoolean();
        this.compactorScanTimeoutNanos = Preconditions.checkNotNegative(properties.getNanos(SCAN_TIMEOUT_MILLIS), SCAN_TIMEOUT_MILLIS.getName());
    }

    public LogBasedCompactor(LogBasedCompactor logBasedCompactor) {
        super(logBasedCompactor.hybridLog.getDevice());
        this.createdAt = logBasedCompactor.createdAt;
        this.hybridLog = logBasedCompactor.hybridLog;
        this.segmentNo = logBasedCompactor.segmentNo;
        this.compactorStateManager = logBasedCompactor.compactorStateManager;
        this.triggeredDeletion = logBasedCompactor.triggeredDeletion;
        this.compactorScanTimeoutNanos = logBasedCompactor.compactorScanTimeoutNanos;
        this.lastVisitedRecordCount = logBasedCompactor.lastVisitedRecordCount;
    }

    protected abstract void doTriggerSegmentsDeletion();

    protected void triggerSegmentsDeletion() {
        if (this.triggeredDeletion.compareAndSet(false, true)) {
            this.doTriggerSegmentsDeletion();
        }
    }

    public abstract boolean isDone();

    public void compactRemaining() {
        this.compact(false);
    }

    @Override
    public void compact() {
        this.compact(true);
    }

    public int getSegmentNo() {
        return this.segmentNo;
    }

    public int getLastVisitedRecordCount() {
        return this.lastVisitedRecordCount;
    }

    protected void setLastVisitedRecordCount(int value) {
        this.lastVisitedRecordCount = value;
    }

    protected boolean isTimedOut(long startNanos, boolean withTimeout) {
        if (!withTimeout || this.compactorScanTimeoutNanos == 0L) {
            return false;
        }
        return System.nanoTime() - startNanos > this.compactorScanTimeoutNanos;
    }

    public CompletableFuture requestCompactorToStop() {
        return this.compactorStateManager.requestCompactorToStop();
    }

    public void trySetCompactorStateBackToRunning() {
        this.compactorStateManager.trySetCompactorStateBackToInitial();
    }

    protected void trySetCompactorStateToStopped() {
        this.compactorStateManager.trySetCompactorStateToStopped();
    }

    protected boolean isInStateRunning() {
        return this.compactorStateManager.isInStateRunning();
    }

    protected void trySetToStateRunning() {
        this.compactorStateManager.trySetToStateRunning();
    }

    protected void pauseEpoch(int threadIndex) {
        Epoch epoch = this.hybridLog.getEpoch();
        epoch.pause(threadIndex);
    }

    protected void resumeEpoch(int threadIndex) {
        Epoch epoch = this.hybridLog.getEpoch();
        epoch.resume(threadIndex);
    }

    protected void assertCompactionDoesNotHappenInMemoryRegion() {
        long highSegmentAddress = this.device.segmentLastLogicalAddress(this.segmentNo);
        assert (highSegmentAddress < this.hybridLog.safeHeadAddress());
    }
}

