/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.compaction.CompactorExecutor;
import com.hazelcast.internal.tstore.compaction.CompactorFutureTask;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

class CompactorExecutorImpl
implements CompactorExecutor {
    private final int compactorThreadCount;
    private final String hzName;
    private final BlockingQueue<CompactorFutureTask> compactorTaskQ;
    private final AtomicBoolean started = new AtomicBoolean();
    private volatile boolean isTerminated;
    private volatile CompactorThread[] threads;

    CompactorExecutorImpl(int executorThreadCount, String hzName) {
        this(executorThreadCount, executorThreadCount, hzName);
    }

    CompactorExecutorImpl(int executorThreadCount, int executorQueueCapacity, String hzName) {
        Invariants.greaterOrEqualThan(executorQueueCapacity, executorThreadCount, "executorQueueCapacity cannot be smaller than executorThreadCount");
        this.hzName = hzName;
        this.compactorTaskQ = new ArrayBlockingQueue<CompactorFutureTask>(executorQueueCapacity);
        this.compactorThreadCount = executorThreadCount;
    }

    void init() {
        if (this.started.get()) {
            return;
        }
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        CompactorThread[] threads = new CompactorThread[this.compactorThreadCount];
        for (int threadId = 0; threadId < threads.length; ++threadId) {
            String threadName = ThreadUtil.createThreadPoolName(this.hzName, "tiered.store.parallel.compactor") + threadId;
            threads[threadId] = new CompactorThread(threadName, this.compactorTaskQ);
            threads[threadId].start();
        }
        this.threads = threads;
    }

    @Override
    public void submit(CompactorFutureTask task) throws InterruptedException {
        if (this.isTerminated) {
            throw new IllegalStateException("the executor has been terminated");
        }
        this.init();
        this.compactorTaskQ.put(task);
    }

    @Override
    public void terminate() {
        if (this.isTerminated) {
            throw new IllegalStateException("the executor has already been terminated");
        }
        this.isTerminated = true;
        if (!this.started.get()) {
            return;
        }
        this.compactorTaskQ.forEach(compactor -> compactor.deregister());
        this.compactorTaskQ.clear();
        for (CompactorThread thread : this.threads) {
            thread.terminate();
        }
    }

    public BlockingQueue<CompactorFutureTask> getCompactorTaskQ() {
        return this.compactorTaskQ;
    }

    public Thread[] getThreads() {
        return this.threads;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    private class CompactorThread
    extends Thread {
        private final ILogger logger;
        private final BlockingQueue<CompactorFutureTask> compactorTaskQ;

        CompactorThread(String threadName, BlockingQueue<CompactorFutureTask> compactorTaskQ) {
            super(threadName);
            this.logger = Logger.getLogger(CompactorThread.class);
            this.compactorTaskQ = compactorTaskQ;
        }

        public void terminate() {
            this.interrupt();
        }

        @Override
        public void run() {
            while (!CompactorExecutorImpl.this.isTerminated && !CompactorThread.currentThread().isInterrupted()) {
                this.run0();
            }
        }

        private void run0() {
            CompactorFutureTask task = null;
            try {
                task = this.compactorTaskQ.take();
                task.run();
            }
            catch (InterruptedException ie) {
                this.logger.finest(this.getClass().getSimpleName() + " was interrupted");
                this.interrupt();
            }
            catch (Throwable th) {
                Throwable throwable = new Throwable("Exception/Error when running " + String.valueOf(task) + ":" + th.getMessage() + System.lineSeparator(), th);
                this.logger.warning(throwable);
            }
        }
    }
}

