/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.CompactionStats;
import com.hazelcast.internal.tstore.compaction.DeviceCapacityChecker;
import com.hazelcast.internal.tstore.compaction.LogBasedCompactor;
import com.hazelcast.internal.tstore.compaction.SynchronizedCompactor;
import com.hazelcast.internal.tstore.compaction.ToHumanReadable;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.recordstore.CompactionAwareStorage;
import javax.annotation.Nullable;

public abstract class AbstractPartitionCompactorStep
implements IMapOpStep {
    private static final int DEFAULT_MAX_FALLBACK_COMPACTION_COUNT = 3;
    private static final int MAX_FALLBACK_COMPACTION_COUNT = Integer.getInteger("hazelcast.tiered.store.partition.compactor.max.fallback.compaction.count", 3);
    private static final double FORCE_COMPACTION_THRESHOLD = 0.666;
    protected final ILogger logger;

    AbstractPartitionCompactorStep(ILogger logger) {
        this.logger = logger;
    }

    public static boolean needsForceCompaction(State state) {
        int sizeBefore = state.getSizeBefore();
        int sizeAfter = state.getSizeAfter();
        if (sizeAfter >= sizeBefore) {
            return false;
        }
        return (double)sizeAfter / (double)sizeBefore < 0.666;
    }

    @Override
    public void runStep(State state) {
        CompactionType compactionType;
        LogBasedCompactor compactor;
        if (!this.isOffloadStep(state)) {
            return;
        }
        boolean force = AbstractPartitionCompactorStep.needsForceCompaction(state);
        HybridLog hybridLog = this.getHybridLogOrNull(state);
        assert (hybridLog != null) : "At this point we must have a HybridLog instance available";
        boolean finestEnabled = this.logger.isFinestEnabled();
        long startNanos = finestEnabled ? System.nanoTime() : -1L;
        LocalStorageDevice device = AbstractPartitionCompactorStep.getDevice(hybridLog);
        long beforeCompactionPartitionGarbageInBytes = device.getPartitionGarbageInBytes();
        int maxFallbackCompactionCount = force ? device.getSegmentCount() : MAX_FALLBACK_COMPACTION_COUNT;
        int fallbackCompactionCount = 0;
        while ((compactor = this.getCompactorOrNull(state, hybridLog, compactionType = force || fallbackCompactionCount > 1 ? CompactionType.FORCED : CompactionType.GC_THRESHOLD_RESPECTED)) != null) {
            compactor.compact();
            this.nullifyCompactorWhenDone(state, compactor);
            if (!force && !device.isOverNodeSoftDeviceCapacity()) break;
            if (!compactor.isDone()) {
                compactor.compactRemaining();
            }
            this.nullifyCompactorWhenDone(state, compactor);
            if (++fallbackCompactionCount < maxFallbackCompactionCount && (force || device.isOverNodeSoftDeviceCapacity())) continue;
        }
        long afterCompactionPartitionGarbageInBytes = device.getPartitionGarbageInBytes();
        if (finestEnabled) {
            this.logCompactorProgress(state, startNanos, beforeCompactionPartitionGarbageInBytes, afterCompactionPartitionGarbageInBytes);
        }
        DeviceCapacityChecker.failOrForgetOutOfCapacity(state, hybridLog, beforeCompactionPartitionGarbageInBytes, afterCompactionPartitionGarbageInBytes);
    }

    private void nullifyCompactorWhenDone(State state, LogBasedCompactor compactor) {
        if (!compactor.isDone()) {
            return;
        }
        CompactionAwareStorage storage = this.getCompactionAwareStorage(state);
        storage.setPartitionCompactor(null);
    }

    @Nullable
    private LogBasedCompactor getCompactorOrNull(State state, HybridLog hybridLog, CompactionType compactionType) {
        LogBasedCompactor partitionCompactor = this.getCurrentCompactorOrNull(state);
        if (partitionCompactor != null && !partitionCompactor.isDone()) {
            return partitionCompactor;
        }
        return this.tryToCreateNewPartitionCompactor(state, hybridLog, compactionType);
    }

    private LogBasedCompactor getCurrentCompactorOrNull(State state) {
        CompactionAwareStorage storage = this.getCompactionAwareStorage(state);
        return storage.getPartitionCompactorOrNull();
    }

    private LogBasedCompactor tryToCreateNewPartitionCompactor(State state, HybridLog hybridLog, CompactionType compactionType) {
        CompactionAwareStorage storage = this.getCompactionAwareStorage(state);
        storage.setPartitionCompactor(null);
        LocalStorageDevice device = AbstractPartitionCompactorStep.getDevice(hybridLog);
        Integer segmentNo = AbstractPartitionCompactorStep.findNextSegmentToCompactOrNull(device, compactionType);
        if (segmentNo == null) {
            return null;
        }
        LogBasedCompactor newPartitionCompactor = storage.newPartitionCompactor(segmentNo);
        newPartitionCompactor = new SynchronizedCompactor(newPartitionCompactor);
        storage.setPartitionCompactor(newPartitionCompactor);
        return newPartitionCompactor;
    }

    private static Integer findNextSegmentToCompactOrNull(LocalStorageDevice device, CompactionType compactionType) {
        if (compactionType == CompactionType.GC_THRESHOLD_RESPECTED) {
            return device.isOverPartitionsCompactionFreeThreshold() ? device.pollFileNoToCompact() : null;
        }
        if (compactionType == CompactionType.FORCED) {
            return device.pollFileNoToCompact();
        }
        throw new IllegalArgumentException("Found an unexpected compaction type=" + String.valueOf((Object)compactionType));
    }

    @Nullable
    abstract HybridLog getHybridLogOrNull(State var1);

    abstract CompactionAwareStorage getCompactionAwareStorage(State var1);

    private static LocalStorageDevice getDevice(HybridLog hybridLog) {
        Device device = ((HybridLogImpl)hybridLog).getDevice();
        return (LocalStorageDevice)device;
    }

    private void logCompactorProgress(State state, long startNanos, long beforeCompactionPartitionGarbageInBytes, long afterCompactionPartitionGarbageInBytes) {
        long compactionFreedInBytes = beforeCompactionPartitionGarbageInBytes - afterCompactionPartitionGarbageInBytes;
        String msg = "Compacted=[mapName=%s, partitionSize=%d, nodeUsed=%s, partitionId=%d, replicaIndex=%d, segmentNo=%d, visitedRecordCount=%d, took=%s, " + (compactionFreedInBytes >= 0L ? "freed" : "increased") + "=%s(%s->%s)]";
        LocalStorageDevice localStorageDevice = AbstractPartitionCompactorStep.getDevice(this.getHybridLogOrNull(state));
        CompactionStats compactionStats = localStorageDevice.getCompactionStats();
        long usedDeviceCapacityInBytes = compactionStats.getUsedDeviceCapacityInBytes();
        CompactionAwareStorage storage = this.getCompactionAwareStorage(state);
        LogBasedCompactor partitionCompactor = storage.getPartitionCompactorOrNull();
        this.logger.finest(String.format(msg, state.getRecordStore().getName(), state.getRecordStore().size(), ToHumanReadable.bytesToString(usedDeviceCapacityInBytes), state.getPartitionId(), state.getOperation().getReplicaIndex(), partitionCompactor == null ? -1 : partitionCompactor.getSegmentNo(), partitionCompactor == null ? -1 : partitionCompactor.getLastVisitedRecordCount(), ToHumanReadable.nanosToString(System.nanoTime() - startNanos), ToHumanReadable.bytesToString(Math.abs(compactionFreedInBytes)), ToHumanReadable.bytesToString(beforeCompactionPartitionGarbageInBytes), ToHumanReadable.bytesToString(afterCompactionPartitionGarbageInBytes)));
    }

    @Override
    public boolean isOffloadStep(State state) {
        HybridLog hybridLog = this.getHybridLogOrNull(state);
        if (hybridLog == null) {
            return false;
        }
        if (AbstractPartitionCompactorStep.needsForceCompaction(state)) {
            return true;
        }
        LocalStorageDevice device = AbstractPartitionCompactorStep.getDevice(hybridLog);
        if (device.hasNoGarbageInPartition()) {
            DeviceCapacityChecker.failOrForgetOutOfCapacity(state, hybridLog, 0L, 0L);
            return false;
        }
        if (device.isOverNodeSoftDeviceCapacity()) {
            return true;
        }
        return device.isOverPartitionsCompactionFreeThreshold();
    }

    @Override
    public Step nextStep(State state) {
        throw new UnsupportedOperationException("This must never be called.");
    }

    @Override
    public String getExecutorName(State state) {
        return "hz:map-tiered-store-compaction-offloadable";
    }

    private static enum CompactionType {
        FORCED,
        GC_THRESHOLD_RESPECTED;

    }
}

