/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization;

import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.serialization.ClassNameFilter;

public class ReflectionClassNameFilter
implements ClassNameFilter {
    private static final String LOAD_CLASS_ERROR = "Creation of class %s is not allowed.";
    private static final String[] DEFAULT_WHITELIST_PREFIX = new String[]{"com.hazelcast.", "java", "["};
    private final ClassFilter blacklist;
    private final ClassFilter whitelist;

    public ReflectionClassNameFilter(JavaSerializationFilterConfig config) {
        Preconditions.checkNotNull(config, "JavaReflectionFilterConfig has to be provided");
        this.blacklist = config.getBlacklist();
        this.whitelist = config.getWhitelist();
        if (!config.isDefaultsDisabled()) {
            this.whitelist.addPrefixes(DEFAULT_WHITELIST_PREFIX);
        }
    }

    @Override
    public void filter(String className) throws SecurityException {
        if (this.blacklist.isListed(className)) {
            throw new SecurityException(String.format(LOAD_CLASS_ERROR, className));
        }
        if (!this.whitelist.isListed(className)) {
            throw new SecurityException(String.format(LOAD_CLASS_ERROR, className));
        }
    }
}

