/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.IOException;
import java.util.UUID;

public class ShutdownResponseOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation,
Versioned {
    private UUID uuid;

    public ShutdownResponseOperation() {
    }

    public ShutdownResponseOperation(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        Address caller = this.getCallerAddress();
        NodeEngine nodeEngine = this.getNodeEngine();
        if (nodeEngine.isRunning()) {
            logger.severe("Received a shutdown response from " + String.valueOf(caller) + ", but this node is not shutting down!");
            return;
        }
        if (partitionService.isMemberMaster(caller)) {
            if (logger.isFinestEnabled()) {
                logger.finest("Received shutdown response from %s", caller);
            }
            if (nodeEngine.getLocalMember().getUuid().equals(this.uuid)) {
                partitionService.onShutdownResponse();
            } else {
                logger.warning("Ignoring shutdown response for " + String.valueOf(this.uuid) + " since it's not the expected member");
            }
        } else {
            logger.warning("Received shutdown response from " + String.valueOf(caller) + " but it's not the known master");
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.uuid = UUIDSerializationUtil.readUUID(in);
    }
}

