/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.merkletree.MerkleTreeCompareOperation;
import com.hazelcast.internal.merkletree.MerkleTreeComparisonProcessor;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.impl.EnterprisePartitionDataSerializerHook;
import com.hazelcast.internal.partition.impl.MerkleTreeComparisonResponse;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;

public class MerkleTreePartitionComparisonOperation<T extends Operation>
extends Operation
implements IdentifiedDataSerializable,
MigrationCycleOperation {
    public static final int[] FULL_SYNC = new int[0];
    public static final int[] NO_SYNC = new int[0];
    private volatile List<String> dataStructureNames = new ArrayList<String>();
    private volatile Address remoteTarget;
    private volatile int partitionId;
    private String compareOperationClassName;
    private final transient ConcurrentMap<String, int[]> result = new ConcurrentHashMap<String, int[]>();
    private final transient ConcurrentMap<String, int[]> dataStructureNameToDiff = new ConcurrentHashMap<String, int[]>();
    private final transient ConcurrentMap<String, MerkleTreeComparisonProcessor> dataStructureNameToProcessor = new ConcurrentHashMap<String, MerkleTreeComparisonProcessor>();

    public MerkleTreePartitionComparisonOperation() {
    }

    public MerkleTreePartitionComparisonOperation(int partitionId, List<String> dataStructureNames, String compareOperationClassName) {
        this.partitionId = partitionId;
        this.dataStructureNames = dataStructureNames;
        this.compareOperationClassName = compareOperationClassName;
    }

    public void setRemoteTarget(Address remoteTarget) {
        this.remoteTarget = remoteTarget;
    }

    @Override
    public void run() throws Exception {
        this.initializeComparison();
        this.compare();
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public int getFactoryId() {
        return EnterprisePartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.write(this.dataStructureNames.size());
        for (String name : this.dataStructureNames) {
            out.writeString(name);
        }
        out.writeObject(this.remoteTarget);
        out.writeString(this.compareOperationClassName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int nameCount = in.readInt();
        for (int i = 0; i < nameCount; ++i) {
            this.dataStructureNames.add(in.readString());
        }
        this.remoteTarget = (Address)in.readObject();
        this.compareOperationClassName = in.readString();
    }

    private boolean comparisonDone() {
        return this.dataStructureNameToDiff.isEmpty();
    }

    public void compare() throws Exception {
        HashSet<String> pendingNames = new HashSet<String>();
        while (!this.comparisonDone()) {
            int[] difference;
            MerkleTreeComparisonProcessor processor;
            this.getLocalNodeValues();
            this.resetPendingNames(pendingNames);
            for (String name : pendingNames) {
                processor = (MerkleTreeComparisonProcessor)this.dataStructureNameToProcessor.get(name);
                processor.processLocalNodeValues((int[])this.dataStructureNameToDiff.get(name));
                if (!processor.isComparisonFinished()) continue;
                difference = processor.getDifference();
                this.result.put(name, difference);
                this.dataStructureNameToDiff.remove(name);
            }
            if (this.comparisonDone()) {
                return;
            }
            this.compareWithRemoteMember();
            this.resetPendingNames(pendingNames);
            for (String name : pendingNames) {
                processor = (MerkleTreeComparisonProcessor)this.dataStructureNameToProcessor.get(name);
                processor.processRemoteNodeValues((int[])this.dataStructureNameToDiff.get(name));
                if (!processor.isComparisonFinished()) continue;
                difference = processor.getDifference();
                this.result.put(name, difference);
                this.dataStructureNameToDiff.remove(name);
            }
        }
    }

    private void resetPendingNames(Set<String> pendingMapNames) {
        pendingMapNames.clear();
        pendingMapNames.addAll(this.dataStructureNameToDiff.keySet());
    }

    private void compareWithRemoteMember() {
        T op = this.prepareCompareOperation();
        InvocationFuture future = this.getNodeEngine().getOperationService().invokeOnTarget(this.getServiceName(), (Operation)op, this.remoteTarget);
        Map responses = (Map)future.joinInternal();
        for (Map.Entry responseEntry : responses.entrySet()) {
            this.processComparisonResponse((String)responseEntry.getKey(), (MerkleTreeComparisonResponse)responseEntry.getValue());
        }
    }

    private void getLocalNodeValues() {
        CountDownLatch sync = new CountDownLatch(1);
        PartitionSpecificRunnableExceptionWrapper runnableExceptionWrapper = new PartitionSpecificRunnableExceptionWrapper(new GetLocalNodeValues(sync));
        this.getNodeEngine().getOperationService().execute(runnableExceptionWrapper);
        try {
            sync.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.sneakyThrow(e);
        }
        Throwable exceptionResult = runnableExceptionWrapper.getExceptionResult();
        if (exceptionResult != null) {
            ExceptionUtil.sneakyThrow(exceptionResult);
        }
    }

    private void processComparisonResponse(String name, MerkleTreeComparisonResponse response) {
        assert (response != null);
        if (response.isFullSyncRequired()) {
            this.result.put(name, FULL_SYNC);
            this.dataStructureNameToDiff.remove(name);
            return;
        }
        int[] comparisonResult = response.getDiff();
        if (comparisonResult.length == 0) {
            this.result.put(name, NO_SYNC);
            this.dataStructureNameToDiff.remove(name);
        } else {
            this.dataStructureNameToDiff.put(name, comparisonResult);
        }
    }

    @Nonnull
    private T prepareCompareOperation() {
        T op = this.newCompareOperation();
        ((MerkleTreeCompareOperation)op).initialize(this.dataStructureNameToDiff);
        ((Operation)op).setNodeEngine(this.getNodeEngine());
        ((Operation)op).setServiceName(this.getServiceName());
        ((Operation)op).setPartitionId(this.partitionId);
        ((Operation)op).setValidateTarget(false);
        ((Operation)op).setOperationResponseHandler((operation, response) -> {});
        return op;
    }

    private void initializeComparison() {
        for (String name : this.dataStructureNames) {
            this.dataStructureNameToDiff.put(name, FULL_SYNC);
            this.dataStructureNameToProcessor.put(name, new MerkleTreeComparisonProcessor());
        }
    }

    private T newCompareOperation() {
        Operation op = null;
        try {
            op = (Operation)ClassLoaderUtil.newInstance(null, this.compareOperationClassName);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return (T)op;
    }

    public static Map<String, int[]> syncGetPartitionMerkleDiff(NodeEngine nodeEngine, String serviceName, PartitionReplicationEvent event, List<String> dataStructureNames, String compareOperationClassName) {
        MerkleTreePartitionComparisonOperation comparisonOperation = new MerkleTreePartitionComparisonOperation(event.getPartitionId(), dataStructureNames, compareOperationClassName);
        comparisonOperation.setNodeEngine(nodeEngine);
        comparisonOperation.setServiceName(serviceName);
        comparisonOperation.setRemoteTarget(event.getTarget());
        InvocationFuture future = nodeEngine.getOperationService().invokeOnTarget(serviceName, comparisonOperation, nodeEngine.getLocalMember().getAddress());
        return (Map)future.joinInternal();
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    private static final class PartitionSpecificRunnableExceptionWrapper
    implements PartitionSpecificRunnable {
        private final PartitionSpecificRunnable partitionSpecificRunnable;
        private volatile Throwable exceptionResult;

        private PartitionSpecificRunnableExceptionWrapper(PartitionSpecificRunnable partitionSpecificRunnable) {
            this.partitionSpecificRunnable = partitionSpecificRunnable;
        }

        @Override
        public int getPartitionId() {
            return this.partitionSpecificRunnable.getPartitionId();
        }

        @Override
        public void run() {
            try {
                this.partitionSpecificRunnable.run();
            }
            catch (Throwable throwable) {
                this.exceptionResult = throwable;
            }
        }

        public Throwable getExceptionResult() {
            return this.exceptionResult;
        }
    }

    private final class GetLocalNodeValues
    implements PartitionSpecificRunnable {
        private final CountDownLatch sync;

        GetLocalNodeValues(CountDownLatch sync) {
            this.sync = sync;
        }

        @Override
        public int getPartitionId() {
            return MerkleTreePartitionComparisonOperation.this.partitionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                OperationService operationService = MerkleTreePartitionComparisonOperation.this.getNodeEngine().getOperationService();
                Object op = MerkleTreePartitionComparisonOperation.this.prepareCompareOperation();
                operationService.run((Operation)op);
                Object response = ((Operation)op).getResponse();
                if (response instanceof Throwable) {
                    Throwable throwable = (Throwable)response;
                    throw ExceptionUtil.sneakyThrow(throwable);
                }
                Map comparisonResponse = (Map)response;
                for (Map.Entry responseEntry : comparisonResponse.entrySet()) {
                    MerkleTreePartitionComparisonOperation.this.processComparisonResponse((String)responseEntry.getKey(), (MerkleTreeComparisonResponse)responseEntry.getValue());
                }
            }
            finally {
                this.sync.countDown();
            }
        }
    }
}

