/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.nativememory;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.internal.nearcache.HDNearCacheRecordStore;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.impl.invalidation.StaleReadDetector;
import com.hazelcast.internal.nearcache.impl.nativememory.HDNearCacheRecord;
import com.hazelcast.internal.nearcache.impl.nativememory.HDNearCacheRecordMap;
import com.hazelcast.internal.nearcache.impl.nativememory.HDNearCacheRecordStoreImpl;
import com.hazelcast.internal.nearcache.impl.nativememory.LockableNearCacheRecordStoreSegment;
import com.hazelcast.internal.nearcache.impl.nativememory.LockableNearCacheRecordStoreSegmentIterator;
import com.hazelcast.internal.nearcache.impl.preloader.NearCachePreloader;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.nearcache.NearCacheStats;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SegmentedHDNearCacheRecordStore<K, V>
implements HDNearCacheRecordStore<K, V, HDNearCacheRecord> {
    static final int DEFAULT_EXPIRY_SAMPLE_COUNT = 1000;
    private static final String PROP_EXPIRY_SAMPLE_COUNT = "hazelcast.internal.hd.near.cache.expiry.sample.count";
    private final int hashSeed;
    private final int segmentMask;
    private final int segmentShift;
    private final int expirySampleCount;
    private final boolean evictionDisabled;
    private final ClassLoader classLoader;
    private final NearCacheStatsImpl nearCacheStats;
    private final HazelcastMemoryManager memoryManager;
    private final NearCachePreloader<Data> nearCachePreloader;
    private final HDNearCacheRecordStoreImpl<K, V>[] segments;
    private final EnterpriseSerializationService serializationService;

    public SegmentedHDNearCacheRecordStore(String name, NearCacheConfig nearCacheConfig, EnterpriseSerializationService serializationService, ClassLoader classLoader) {
        int segmentCount;
        this.serializationService = serializationService;
        this.classLoader = classLoader;
        this.nearCacheStats = new NearCacheStatsImpl();
        this.memoryManager = this.getMemoryManager(serializationService);
        this.evictionDisabled = nearCacheConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.NONE;
        int concurrencyLevel = Math.max(16, 8 * RuntimeAvailableProcessors.get());
        int segmentShift = 0;
        for (segmentCount = 1; segmentCount < concurrencyLevel; segmentCount <<= 1) {
            ++segmentShift;
        }
        this.hashSeed = this.hashCode();
        this.segmentMask = segmentCount - 1;
        this.segmentShift = 32 - segmentShift;
        HiDensityStorageInfo storageInfo = new HiDensityStorageInfo(nearCacheConfig.getName());
        this.expirySampleCount = Integer.getInteger(PROP_EXPIRY_SAMPLE_COUNT, 1000);
        int perSegmentExpirySampleCount = (int)Math.ceil(1.0 * (double)this.expirySampleCount / (double)segmentCount);
        this.segments = this.createSegments(nearCacheConfig, this.nearCacheStats, storageInfo, segmentCount, perSegmentExpirySampleCount);
        this.nearCachePreloader = this.createPreloader(name, nearCacheConfig, serializationService);
    }

    @Override
    public void initialize() {
    }

    private HazelcastMemoryManager getMemoryManager(EnterpriseSerializationService serializationService) {
        HazelcastMemoryManager memoryManager = serializationService.getMemoryManager();
        if (memoryManager instanceof PoolingMemoryManager) {
            PoolingMemoryManager manager = (PoolingMemoryManager)memoryManager;
            return manager.getGlobalMemoryManager();
        }
        return memoryManager;
    }

    private HDNearCacheRecordStoreImpl<K, V>[] createSegments(NearCacheConfig nearCacheConfig, NearCacheStatsImpl nearCacheStats, HiDensityStorageInfo storageInfo, int segmentCount, int perSegmentExpirySampleCount) {
        HDNearCacheRecordStoreImpl[] segments = new HDNearCacheRecordStoreImpl[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            segments[i] = new HDNearCacheRecordStoreSegment(nearCacheConfig, nearCacheStats, storageInfo, this.serializationService, this.classLoader, perSegmentExpirySampleCount);
            segments[i].initialize();
        }
        return segments;
    }

    private NearCachePreloader<Data> createPreloader(String name, NearCacheConfig nearCacheConfig, SerializationService serializationService) {
        NearCachePreloaderConfig preloaderConfig = nearCacheConfig.getPreloaderConfig();
        if (preloaderConfig.isEnabled()) {
            return new NearCachePreloader<Data>(name, preloaderConfig, this.nearCacheStats, serializationService);
        }
        return null;
    }

    private int hash(Object o) {
        int h = this.hashSeed;
        h ^= o.hashCode();
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public HDNearCacheRecordStoreImpl<K, V>[] getSegments() {
        return this.segments;
    }

    @Override
    public V get(K key) {
        HDNearCacheRecordStoreImpl<K, V> segment = this.segmentFor(key);
        return segment.get(key);
    }

    @Override
    public NearCacheRecord getRecord(K key) {
        HDNearCacheRecordStoreImpl<K, V> segment = this.segmentFor(key);
        return segment.getRecord((Object)key);
    }

    @Override
    public void put(K key, Data keyData, V value, Data valueData) {
        HDNearCacheRecordStoreImpl<K, V> segment = this.segmentFor(key);
        segment.put(key, keyData, value, valueData);
    }

    @Override
    public void invalidate(K key) {
        HDNearCacheRecordStoreImpl<K, V> segment = this.segmentFor(key);
        segment.invalidate(key);
    }

    private HDNearCacheRecordStoreImpl<K, V> segmentFor(K key) {
        int hash = this.hash(key);
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public void clear() {
        for (HDNearCacheRecordStoreImpl<K, V> segment : this.segments) {
            segment.clear();
        }
        this.nearCacheStats.setOwnedEntryCount(0L);
        this.nearCacheStats.setOwnedEntryMemoryCost(0L);
    }

    @Override
    public void destroy() {
        for (HDNearCacheRecordStoreImpl<K, V> segment : this.segments) {
            segment.destroy();
        }
        this.nearCacheStats.setOwnedEntryCount(0L);
        this.nearCacheStats.setOwnedEntryMemoryCost(0L);
        if (this.nearCachePreloader != null) {
            this.nearCachePreloader.destroy();
        }
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        return this.nearCacheStats;
    }

    @Override
    public int size() {
        int size = 0;
        for (HDNearCacheRecordStoreImpl<K, V> segment : this.segments) {
            size += segment.size();
        }
        return size;
    }

    @Override
    public int forceEvict() {
        int evictedCount = 0;
        for (HDNearCacheRecordStoreImpl<K, V> segment : this.segments) {
            evictedCount += segment.forceEvict();
        }
        return evictedCount;
    }

    @Override
    public void doExpiration() {
        Thread currentThread = Thread.currentThread();
        for (HDNearCacheRecordStoreImpl<K, V> segment : this.segments) {
            if (currentThread.isInterrupted()) {
                return;
            }
            segment.doExpiration();
        }
    }

    @Override
    public boolean doEviction(boolean withoutMaxSizeCheck) {
        if (this.evictionDisabled) {
            return false;
        }
        Thread currentThread = Thread.currentThread();
        for (HDNearCacheRecordStoreImpl<K, V> segment : this.segments) {
            if (currentThread.isInterrupted()) {
                return false;
            }
            segment.doEviction(withoutMaxSizeCheck);
        }
        return true;
    }

    @Override
    public void loadKeys(DataStructureAdapter<Object, ?> adapter) {
        this.nearCachePreloader.loadKeys(adapter);
    }

    @Override
    public void storeKeys() {
        LockableNearCacheRecordStoreSegmentIterator iterator = new LockableNearCacheRecordStoreSegmentIterator(this.segments);
        try {
            this.nearCachePreloader.storeKeys(iterator);
        }
        finally {
            IOUtil.closeResource(iterator);
        }
    }

    @Override
    public void setStaleReadDetector(StaleReadDetector staleReadDetector) {
        for (HDNearCacheRecordStoreImpl<K, V> segment : this.segments) {
            segment.setStaleReadDetector(staleReadDetector);
        }
    }

    @Override
    public long tryReserveForUpdate(K key, Data keyData, NearCache.UpdateSemantic updateSemantic) {
        HDNearCacheRecordStoreImpl<K, V> segment = this.segmentFor(key);
        return segment.tryReserveForUpdate(key, keyData, updateSemantic);
    }

    @Override
    public V tryPublishReserved(K key, V value, long reservationId, boolean deserialize) {
        HDNearCacheRecordStoreImpl<K, V> segment = this.segmentFor(key);
        return segment.tryPublishReserved(key, value, reservationId, deserialize);
    }

    @Override
    public HazelcastMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    class HDNearCacheRecordStoreSegment
    extends HDNearCacheRecordStoreImpl<K, V>
    implements LockableNearCacheRecordStoreSegment {
        private static final long READ_LOCK_TIMEOUT_IN_MILLISECONDS = 25L;
        private final Lock lock;

        HDNearCacheRecordStoreSegment(NearCacheConfig nearCacheConfig, NearCacheStatsImpl nearCacheStats, HiDensityStorageInfo storageInfo, EnterpriseSerializationService ss, ClassLoader classLoader, int sampleCount) {
            super(nearCacheConfig, nearCacheStats, storageInfo, ss, classLoader, sampleCount);
            this.lock = new ReentrantLock();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V get(K key) {
            try {
                if (!this.lock.tryLock(25L, TimeUnit.MILLISECONDS)) return null;
                try {
                    Object v = super.get(key);
                    return v;
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(K key, Data keyData, V value, Data valueData) {
            this.lock.lock();
            try {
                super.put(key, keyData, value, valueData);
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void invalidate(K key) {
            this.lock.lock();
            try {
                super.invalidate(key);
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void clear() {
            this.lock.lock();
            try {
                super.clear();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void destroy() {
            this.lock.lock();
            try {
                super.destroy();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public int forceEvict() {
            this.lock.lock();
            try {
                int n = super.forceEvict();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void doExpiration() {
            this.lock.lock();
            try {
                super.doExpiration();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean doEviction(boolean withoutMaxSizeCheck) {
            this.lock.lock();
            try {
                boolean bl = super.doEviction(withoutMaxSizeCheck);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long tryReserveForUpdate(K key, Data keyData, NearCache.UpdateSemantic updateSemantic) {
            this.lock.lock();
            try {
                long l = super.tryReserveForUpdate(key, keyData, updateSemantic);
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V tryPublishReserved(K key, V value, long reservationId, boolean deserialize) {
            this.lock.lock();
            try {
                Object v = super.tryPublishReserved(key, value, reservationId, deserialize);
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public StaleReadDetector getStaleReadDetector() {
            this.lock.lock();
            try {
                StaleReadDetector staleReadDetector = super.getStaleReadDetector();
                return staleReadDetector;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Iterator<Data> getKeySetIterator() {
            this.checkAvailable();
            return ((HDNearCacheRecordMap)this.records).keySet().iterator();
        }

        @Override
        public void lock() {
            this.lock.lock();
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }
    }
}

