/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.management;

import com.hazelcast.cp.CPMember;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.management.TimedMemberStateFactory;
import com.hazelcast.internal.monitor.impl.MemberStateImpl;
import com.hazelcast.internal.monitor.impl.management.EnterpriseNodeStateImpl;
import com.hazelcast.internal.monitor.impl.rest.LicenseInfoImpl;
import com.hazelcast.internal.services.StatisticsAwareService;
import com.hazelcast.security.impl.WeakSecretError;
import com.hazelcast.security.impl.WeakSecretsConfigChecker;
import com.hazelcast.vector.impl.VectorCollectionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnterpriseTimedMemberStateFactory
extends TimedMemberStateFactory {
    private final Map<String, List<String>> weakSecretsReport = new HashMap<String, List<String>>();

    public EnterpriseTimedMemberStateFactory(HazelcastInstanceImpl instance) {
        super(instance);
        this.evaluateWeakSecretsInConfig();
    }

    @Override
    protected void createNodeState(MemberStateImpl memberState) {
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)this.instance.node.getNodeExtension();
        LicenseInfoImpl licenseInfo = new LicenseInfoImpl(nodeExtension.getLicense());
        Node node = this.instance.node;
        ClusterServiceImpl cluster = this.instance.node.clusterService;
        EnterpriseNodeStateImpl nodeState = new EnterpriseNodeStateImpl(cluster.getClusterState(), node.getState(), cluster.getClusterVersion(), node.getVersion(), this.weakSecretsReport, licenseInfo);
        memberState.setNodeState(nodeState);
    }

    private void evaluateWeakSecretsInConfig() {
        WeakSecretsConfigChecker weakSecretsConfigChecker = new WeakSecretsConfigChecker(this.instance.getConfig());
        Map<String, EnumSet<WeakSecretError>> report = weakSecretsConfigChecker.evaluate();
        for (Map.Entry<String, EnumSet<WeakSecretError>> entry : report.entrySet()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (WeakSecretError error : entry.getValue()) {
                errors.add(error.name());
            }
            this.weakSecretsReport.put(entry.getKey(), errors);
        }
    }

    @Override
    protected void setCPMemberUuid(MemberStateImpl memberState) {
        if (this.instance.getConfig().getCPSubsystemConfig().getCPMemberCount() == 0) {
            memberState.setCpMemberUuid(null);
        } else {
            CPMember localCPMember = this.instance.getCPSubsystem().getLocalCPMember();
            memberState.setCpMemberUuid(localCPMember != null ? localCPMember.getUuid() : null);
        }
    }

    @Override
    protected void createMemState(MemberStateImpl memberState, Collection<StatisticsAwareService> services) {
        super.createMemState(memberState, services);
        VectorCollectionService vcService = (VectorCollectionService)this.instance.node.nodeEngine.getService("hz:service:vector");
        memberState.setVectorCollections(vcService.getAllExistingVectorCollectionNames());
    }
}

