/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl.jmx;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.jmx.InstanceMBean;
import com.hazelcast.internal.jmx.ManagedExecutorServiceMBean;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.internal.monitor.impl.jmx.LicenseInfoMBean;
import com.hazelcast.internal.monitor.impl.rest.LicenseInfoImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.vector.impl.VectorCollectionService;

public class EnterpriseManagementService
extends ManagementService {
    public EnterpriseManagementService(HazelcastInstanceImpl instance) {
        super(instance);
    }

    @Override
    protected InstanceMBean createInstanceMBean(HazelcastInstanceImpl instance) {
        return new EnterpriseInstanceMBean(instance, (ManagementService)this);
    }

    public static class EnterpriseInstanceMBean
    extends InstanceMBean {
        private LicenseInfoMBean licenseInfoMBean;
        private ManagedExecutorServiceMBean vectorQueryExecutorMBean;

        EnterpriseInstanceMBean(HazelcastInstanceImpl hazelcastInstance, ManagementService managementService) {
            super(hazelcastInstance, managementService);
            this.createAndRegisterLicenseMBean(hazelcastInstance, managementService);
            Node node = hazelcastInstance.node;
            ExecutionService executionService = node.nodeEngine.getExecutionService();
            this.createEnterpriseMBeans(hazelcastInstance, node, executionService);
            this.registerEnterpriseMBeans();
        }

        private void createAndRegisterLicenseMBean(HazelcastInstanceImpl hazelcastInstance, ManagementService managementService) {
            EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)hazelcastInstance.node.getNodeExtension();
            LicenseInfoImpl licenseInfo = new LicenseInfoImpl(nodeExtension.getLicense());
            this.licenseInfoMBean = new LicenseInfoMBean(licenseInfo, hazelcastInstance.node, managementService);
            EnterpriseInstanceMBean.register(this.licenseInfoMBean);
        }

        private void createEnterpriseMBeans(HazelcastInstance hazelcastInstance, Node node, ExecutionService executionService) {
            VectorCollectionService vectorCollectionService = (VectorCollectionService)node.getNodeEngine().getService("hz:service:vector");
            this.vectorQueryExecutorMBean = vectorCollectionService.isEnabled() ? new ManagedExecutorServiceMBean(hazelcastInstance, executionService.getExecutor("hz:vector-query"), this.service) : null;
        }

        private void registerEnterpriseMBeans() {
            if (this.vectorQueryExecutorMBean != null) {
                EnterpriseInstanceMBean.register(this.vectorQueryExecutorMBean);
            }
        }

        public LicenseInfoMBean getLicenseInfoMBean() {
            return this.licenseInfoMBean;
        }

        public ManagedExecutorServiceMBean getVectorQueryExecutorMBean() {
            return this.vectorQueryExecutorMBean;
        }
    }
}

