/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.memory.NativeMemoryStats;
import com.hazelcast.memory.Capacity;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class PooledNativeMemoryStats
extends NativeMemoryStats
implements MemoryStats {
    private final LongAdder usedNative = new LongAdder();
    private final AtomicLong usedMetadata = new AtomicLong();
    private final int pageSize;
    private final long maxData;
    private final long maxMetadata;

    public PooledNativeMemoryStats(long maxNative, long maxMetadata, int pageSize) {
        super(maxNative);
        this.maxMetadata = maxMetadata;
        this.pageSize = pageSize;
        this.maxData = maxNative - maxMetadata;
    }

    @Override
    public final long getMaxMetadata() {
        return this.maxMetadata;
    }

    @Override
    public long getUsedNative() {
        return this.usedNative.sum();
    }

    final void addUsedNativeMemory(long size) {
        this.usedNative.add(size);
    }

    final void removeUsedNativeMemory(long size) {
        this.usedNative.add(-size);
    }

    final void addMetadataUsage(long size) {
        this.usedMetadata.addAndGet(size);
        this.usedNative.add(size);
    }

    final void removeMetadataUsage(long size) {
        this.usedMetadata.addAndGet(-size);
        this.usedNative.add(-size);
        this.committedNative.addAndGet(-size);
        this.adjustMaxNative(size);
    }

    final void removeTSNativeUsage(long size) {
        this.usedNative.add(-size);
        this.committedNative.addAndGet(-size);
        this.adjustMaxNative(size);
    }

    private void adjustMaxNative(long size) {
        long configuredMaxNative;
        long maxNative;
        while ((maxNative = this.getMaxNative()) > (configuredMaxNative = this.getConfiguredMaxNative())) {
            assert (maxNative - size >= 0L);
            long nextMaxNative = maxNative - size;
            nextMaxNative = nextMaxNative < configuredMaxNative ? configuredMaxNative : nextMaxNative;
            if (!this.casMaxNative(maxNative, nextMaxNative)) continue;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getMaxData() {
        return this.maxData;
    }

    @Override
    public final long getUsedMetadata() {
        return this.usedMetadata.get();
    }

    @Override
    void appendAdditionalToString(StringBuilder sb) {
        sb.append(", Max Metadata: ").append(Capacity.toPrettyString(this.maxMetadata));
        sb.append(", Used Metadata: ").append(Capacity.toPrettyString(this.usedMetadata.get()));
    }

    void resetUsedNativeMemory() {
        this.usedNative.reset();
    }
}

