/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory;

import com.hazelcast.internal.elastic.queue.LongLinkedBlockingQueue;
import com.hazelcast.internal.elastic.queue.LongQueue;
import com.hazelcast.internal.memory.AbstractPoolingMemoryManager;
import com.hazelcast.internal.memory.AddressQueue;
import com.hazelcast.internal.memory.DestroyedAddressQueue;
import com.hazelcast.internal.memory.GarbageCollectable;
import com.hazelcast.internal.memory.GarbageCollector;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.NativeOutOfMemoryError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;

final class GlobalPoolingMemoryManager
extends AbstractPoolingMemoryManager {
    private static final int HEADER_SIZE = 4;
    private static final int EXTERNAL_BLOCK_BIT = 31;
    private static final int AVAILABLE_BIT = 30;
    private static final int SIZE_SHIFT_COUNT = 3;
    private static final int INITIAL_CAPACITY = 2048;
    private static final int PAGE_LOOKUP_LENGTH = Integer.getInteger("hazelcast.memory.pageLookupLength", 0x1000000);
    private static final int PAGE_LOOKUP_SIZE = PAGE_LOOKUP_LENGTH >> 3 >> 3;
    private static final int PAGE_LOOKUP_MASK = PAGE_LOOKUP_LENGTH - 1;
    private final GarbageCollector gc;
    private final ConcurrentNavigableMap<Long, Object> pageAllocations = new ConcurrentSkipListMap<Long, Object>();
    private final ConcurrentMap<Long, Long> externalAllocations = new ConcurrentHashMap<Long, Long>();
    private final long pageLookupAddress;
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private volatile long lastFullCompaction;

    GlobalPoolingMemoryManager(int minBlockSize, int pageSize, LibMalloc malloc, PooledNativeMemoryStats stats, GarbageCollector gc) {
        super(minBlockSize, pageSize, malloc, stats);
        this.gc = gc;
        this.pageLookupAddress = this.initPageLookup();
        this.initializeAddressQueues();
    }

    private long initPageLookup() {
        long pageLookupAddr = 0L;
        try {
            pageLookupAddr = this.systemAllocator.allocate(PAGE_LOOKUP_SIZE);
            GlobalMemoryAccessorRegistry.AMEM.setMemory(pageLookupAddr, PAGE_LOOKUP_SIZE, (byte)0);
        }
        catch (NativeOutOfMemoryError oome) {
            EmptyStatement.ignore(oome);
        }
        return pageLookupAddr;
    }

    private static int encodeSize(int size) {
        return size >> 3;
    }

    private static int decodeSize(int size) {
        return size << 3;
    }

    private int initHeader(int size) {
        return Bits.setBit(GlobalPoolingMemoryManager.encodeSize(size), 30);
    }

    private long getHeaderAddress(long address) {
        if (this.isPageBaseAddress(address)) {
            return address + (long)this.pageSize - 4L;
        }
        return address - 4L;
    }

    private int getHeader(long address) {
        long headerAddress = this.getHeaderAddress(address);
        return GlobalMemoryAccessorRegistry.AMEM.getIntVolatile(null, headerAddress);
    }

    private static boolean isHeaderAvailable(int header) {
        return Bits.isBitSet(header, 30);
    }

    private boolean isAddressAvailable(long address) {
        int header = this.getHeader(address);
        return GlobalPoolingMemoryManager.isHeaderAvailable(header);
    }

    private static int getSizeFromHeader(int header) {
        int size = Bits.clearBit(header, 30);
        return GlobalPoolingMemoryManager.decodeSize(size);
    }

    private int getSizeFromAddress(long address) {
        int header = this.getHeader(address);
        return GlobalPoolingMemoryManager.getSizeFromHeader(header);
    }

    private static int makeHeaderAvailable(int header) {
        return Bits.setBit(header, 30);
    }

    private static int makeHeaderUnavailable(int header) {
        return Bits.clearBit(header, 30);
    }

    private boolean isPageBaseAddress(long address) {
        if (this.pageLookupAddress == 0L) {
            return this.pageAllocations.containsKey(address);
        }
        int idx = (int)(address & (long)PAGE_LOOKUP_MASK) >> 3;
        int lookupIndex = idx >> 3 & 0xFFFFFFFC;
        byte lookupOffset = (byte)(idx & 0x1F);
        assert (lookupIndex >= 0 && lookupIndex < PAGE_LOOKUP_SIZE);
        int lookupValue = GlobalMemoryAccessorRegistry.AMEM.getIntVolatile(null, this.pageLookupAddress + (long)lookupIndex);
        if (!Bits.isBitSet(lookupValue, lookupOffset)) {
            return false;
        }
        return this.pageAllocations.containsKey(address);
    }

    private void markPageLookup(long pageAddress) {
        int newLookupValue;
        int currentLookupValue;
        if (this.pageLookupAddress == 0L) {
            return;
        }
        int idx = (int)(pageAddress & (long)PAGE_LOOKUP_MASK) >> 3;
        int lookupIndex = idx >> 3 & 0xFFFFFFFC;
        byte lookupOffset = (byte)(idx & 0x1F);
        while (!GlobalMemoryAccessorRegistry.AMEM.compareAndSwapInt(null, this.pageLookupAddress + (long)lookupIndex, currentLookupValue = GlobalMemoryAccessorRegistry.AMEM.getIntVolatile(null, this.pageLookupAddress + (long)lookupIndex), newLookupValue = Bits.setBit(currentLookupValue, (int)lookupOffset))) {
        }
    }

    @Override
    protected AddressQueue createAddressQueue(int index, int memorySize) {
        return new GlobalAddressQueue(index, memorySize);
    }

    @Override
    protected int headerSize() {
        return 4;
    }

    @Override
    protected void onMallocPage(long pageAddress) {
        boolean added;
        GlobalPoolingMemoryManager.assertValidAddress(pageAddress);
        boolean bl = added = this.pageAllocations.put(pageAddress, Boolean.TRUE) == null;
        if (added) {
            this.markPageLookup(pageAddress);
        }
        assert (added) : "Duplicate malloc() for page address: " + pageAddress;
        this.lastFullCompaction = 0L;
    }

    @Override
    protected void onOome(NativeOutOfMemoryError e) {
        long now = Clock.currentTimeMillis();
        if (now > this.lastFullCompaction + 1000L) {
            this.lastFullCompaction = now;
            this.compact();
            this.lastFullCompaction = now;
        }
    }

    @Override
    protected void initialize(long address, int size, int offset) {
        GlobalPoolingMemoryManager.assertValidAddress(address);
        assert (QuickMath.isPowerOfTwo(size)) : "Size must be power of two, got " + size;
        assert (size >= this.minBlockSize) : "Size must be greater than or equal to minimum block size of " + this.minBlockSize + ", got " + size;
        int header = this.initHeader(size);
        long headerAddress = this.toHeaderAddress(address, offset);
        if (!GlobalMemoryAccessorRegistry.AMEM.compareAndSwapInt(null, headerAddress, 0, header)) {
            throw new IllegalArgumentException("Wrong size, cannot initialize! Address: " + address + ", Size: " + size + ", Header: " + this.getSizeFromAddress(address));
        }
    }

    @Override
    protected long allocateExternalBlock(long size) {
        long allocationSize = size + 8L;
        long address = this.pageAllocator.allocate(allocationSize);
        Long existingAllocationSize = this.externalAllocations.putIfAbsent(address, allocationSize);
        if (existingAllocationSize != null) {
            this.pageAllocator.free(address, allocationSize);
            throw new AssertionError((Object)("Duplicate malloc() for external address " + address));
        }
        int header = Bits.setBit(0, 31);
        long internalHeaderAddress = address + 8L - 4L;
        GlobalMemoryAccessorRegistry.AMEM.putIntVolatile(null, internalHeaderAddress, header);
        return address + 8L;
    }

    @Override
    protected void freeExternalBlock(long address, long size) {
        long allocationSize = size + 8L;
        long allocationAddress = address - 8L;
        Long actualAllocationSize = (Long)this.externalAllocations.remove(allocationAddress);
        if (actualAllocationSize == null) {
            throw new AssertionError((Object)("Double free attempt detected for external address " + address + " of size " + size));
        }
        long actualSize = actualAllocationSize - 8L;
        if (actualSize != size) {
            this.externalAllocations.put(allocationAddress, actualAllocationSize);
            throw new AssertionError((Object)String.format("The call free(%x, %x) refers to an externally allocated block, but the supplied size is wrong. Actual block size is %x", address, size, actualSize));
        }
        this.pageAllocator.free(allocationAddress, allocationSize);
    }

    @Override
    protected void markAvailable(long address) {
        GlobalPoolingMemoryManager.assertValidAddress(address);
        long headerAddress = this.getHeaderAddress(address);
        int header = GlobalMemoryAccessorRegistry.AMEM.getIntVolatile(null, headerAddress);
        assert (!GlobalPoolingMemoryManager.isHeaderAvailable(header)) : "Address " + address + " has been already marked as available!";
        long pageBase = this.getOwningPage(address);
        if (pageBase == 0L) {
            throw new IllegalArgumentException("Address " + address + " does not belong to this memory pool!");
        }
        int size = GlobalPoolingMemoryManager.getSizeFromHeader(header);
        assert (pageBase + (long)this.pageSize >= address + (long)size) : String.format("Block [%,d-%,d] partially overlaps page [%,d-%,d]", address, address + (long)size - 1L, pageBase, pageBase + (long)this.pageSize - 1L);
        int availableHeader = GlobalPoolingMemoryManager.makeHeaderAvailable(header);
        GlobalMemoryAccessorRegistry.AMEM.putIntVolatile(null, headerAddress, availableHeader);
    }

    @Override
    protected boolean markUnavailable(long address, int usedSize, int internalSize) {
        GlobalPoolingMemoryManager.assertValidAddress(address);
        long headerAddress = this.getHeaderAddress(address);
        int header = GlobalMemoryAccessorRegistry.AMEM.getIntVolatile(null, headerAddress);
        if (GlobalPoolingMemoryManager.getSizeFromHeader(header) != internalSize) {
            return false;
        }
        int availableHeader = GlobalPoolingMemoryManager.makeHeaderAvailable(header);
        int unavailableHeader = GlobalPoolingMemoryManager.makeHeaderUnavailable(header);
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapInt(null, headerAddress, availableHeader, unavailableHeader);
    }

    @Override
    protected boolean isAvailable(long address) {
        return this.isAddressAvailable(address);
    }

    @Override
    protected boolean markInvalid(long address, int expectedSize, int offset) {
        GlobalPoolingMemoryManager.assertValidAddress(address);
        long headerAddress = this.toHeaderAddress(address, offset);
        int expectedHeader = this.initHeader(expectedSize);
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapInt(null, headerAddress, expectedHeader, 0);
    }

    @Override
    protected boolean isValidAndAvailable(long address, int expectedSize) {
        GlobalPoolingMemoryManager.assertValidAddress(address);
        int header = this.getHeader(address);
        boolean available = GlobalPoolingMemoryManager.isHeaderAvailable(header);
        if (!available) {
            return false;
        }
        int size = GlobalPoolingMemoryManager.getSizeFromHeader(header);
        return size == expectedSize;
    }

    private long findSizeExternal(long address) {
        long allocationAddress = address - 8L;
        Long allocationSize = (Long)this.externalAllocations.get(allocationAddress);
        if (allocationSize == null) {
            return -1L;
        }
        return allocationSize;
    }

    private long findSize(long address, int header) {
        if (Bits.isBitSet(header, 31)) {
            return this.findSizeExternal(address);
        }
        return GlobalPoolingMemoryManager.getSizeFromHeader(header);
    }

    @Override
    protected long getSizeInternal(long address) {
        int header = this.getHeader(address);
        return this.findSize(address, header);
    }

    @Override
    public long validateAndGetAllocatedSize(long address) {
        GlobalPoolingMemoryManager.assertValidAddress(address);
        int header = this.getHeader(address);
        long size = this.findSize(address, header);
        if (size > (long)this.pageSize) {
            return size;
        }
        if (GlobalPoolingMemoryManager.isHeaderAvailable(header) || !QuickMath.isPowerOfTwo(size) || size < (long)this.minBlockSize) {
            return -1L;
        }
        long page = this.getOwningPage(address);
        return page != 0L && page + (long)this.pageSize >= address + size ? size : -1L;
    }

    @Override
    protected int getOffsetWithinPage(long address) {
        return (int)(address - this.getOwningPage(address));
    }

    private long getOwningPage(long address) {
        Long pageBase = this.pageAllocations.floorKey(address);
        return pageBase != null && pageBase + (long)this.pageSize - 1L >= address ? pageBase : 0L;
    }

    @Override
    public void dispose() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        for (int i = 0; i < this.addressQueues.length; ++i) {
            AddressQueue q = this.addressQueues[i];
            if (q == null) continue;
            q.destroy();
            this.addressQueues[i] = DestroyedAddressQueue.INSTANCE;
        }
        this.freePageAllocations();
        this.freeExternalAllocations();
        if (this.pageLookupAddress != 0L) {
            this.systemAllocator.free(this.pageLookupAddress, PAGE_LOOKUP_SIZE);
        }
    }

    private void freePageAllocations() {
        if (!this.pageAllocations.isEmpty()) {
            for (Long address : this.pageAllocations.keySet()) {
                this.freePage(address);
            }
            this.pageAllocations.clear();
        }
    }

    private void freeExternalAllocations() {
        if (!this.externalAllocations.isEmpty()) {
            Iterator iterator = this.externalAllocations.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                long address = (Long)entry.getKey();
                long size = (Long)entry.getValue();
                this.pageAllocator.free(address, size);
                iterator.remove();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.destroyed.get();
    }

    @Override
    protected int getQueueMergeThreshold(AddressQueue queue) {
        return 2048;
    }

    @Override
    protected Counter newCounter() {
        return MwCounter.newMwCounter();
    }

    public String toString() {
        return "GlobalPoolingMemoryManager";
    }

    @SuppressFBWarnings(value={"BC_IMPOSSIBLE_CAST", "BC_IMPOSSIBLE_INSTANCEOF"})
    private final class GlobalAddressQueue
    implements AddressQueue,
    GarbageCollectable {
        private final int index;
        private final int memorySize;
        private final LongQueue queue;
        private final AtomicBoolean compactionFlag = new AtomicBoolean();

        private GlobalAddressQueue(int index, int memorySize) {
            this.index = index;
            this.memorySize = memorySize;
            this.queue = this.createQueue();
            this.registerGC();
        }

        private LongLinkedBlockingQueue createQueue() {
            return new LongLinkedBlockingQueue(GlobalPoolingMemoryManager.this.systemAllocator, 0L);
        }

        private void registerGC() {
            if (this.queue instanceof GarbageCollectable) {
                GlobalPoolingMemoryManager.this.gc.registerGarbageCollectable((GarbageCollectable)((Object)this.queue));
            }
            GlobalPoolingMemoryManager.this.gc.registerGarbageCollectable(this);
        }

        @Override
        public boolean beforeCompaction() {
            return this.compactionFlag.compareAndSet(false, true);
        }

        @Override
        public void afterCompaction() {
            this.compactionFlag.set(false);
        }

        @Override
        public long acquire() {
            return this.queue.poll();
        }

        @Override
        public boolean release(long address) {
            if (address == 0L) {
                throw new IllegalArgumentException("Illegal memory address: " + address);
            }
            return this.queue.offer(address);
        }

        @Override
        public int getMemorySize() {
            return this.memorySize;
        }

        @Override
        public int capacity() {
            return this.queue.capacity();
        }

        @Override
        public int remaining() {
            return this.queue.size();
        }

        @Override
        public void destroy() {
            if (this.queue instanceof GarbageCollectable) {
                GlobalPoolingMemoryManager.this.gc.deregisterGarbageCollectable((GarbageCollectable)((Object)this.queue));
            }
            GlobalPoolingMemoryManager.this.gc.deregisterGarbageCollectable(this);
            this.queue.dispose();
        }

        @Override
        public void gc() {
            GlobalPoolingMemoryManager.this.compact(this);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "GlobalAddressQueue{memorySize=" + Capacity.toPrettyString(this.memorySize) + "}";
        }
    }
}

