/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.tracker;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.KeyHandleOffHeap;
import com.hazelcast.internal.hotrestart.impl.SimpleHandleOffHeap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.Tracker;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMap;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerMapBase;
import com.hazelcast.internal.hotrestart.impl.gc.tracker.TrackerOffHeap;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryManager;
import com.hazelcast.internal.util.hashslot.HashSlotArray16byteKey;
import com.hazelcast.internal.util.hashslot.HashSlotCursor16byteKey;
import com.hazelcast.internal.util.hashslot.SlotAssignmentResult;
import com.hazelcast.internal.util.hashslot.impl.HashSlotArray16byteKeyImpl;

public final class TrackerMapOffHeap
extends TrackerMapBase {
    private static final int INITIAL_CAPACITY = 512;
    private final HashSlotArray16byteKey trackers;
    private final TrackerOffHeap tr = new TrackerOffHeap();

    public TrackerMapOffHeap(MemoryManager memMgr, MemoryAllocator auxMalloc) {
        this.trackers = new HashSlotArray16byteKeyImpl(Long.MIN_VALUE, memMgr, auxMalloc, 16, 512, 0.6f);
        this.trackers.gotoNew();
    }

    @Override
    public Tracker putIfAbsent(KeyHandle kh, long chunkSeq, boolean isTombstone) {
        KeyHandleOffHeap ohk = (KeyHandleOffHeap)kh;
        SlotAssignmentResult slot = this.trackers.ensure(ohk.address(), ohk.sequenceId());
        this.tr.address = slot.address();
        if (!slot.isNew()) {
            return this.tr;
        }
        this.tr.setLiveState(chunkSeq, isTombstone);
        this.tr.resetGarbageCount();
        this.added(isTombstone);
        return null;
    }

    @Override
    public Tracker get(KeyHandle kh) {
        KeyHandleOffHeap handle = (KeyHandleOffHeap)kh;
        long addr = this.trackers.get(handle.address(), handle.sequenceId());
        if (addr == 0L) {
            return null;
        }
        this.tr.address = addr;
        return this.tr;
    }

    @Override
    void doRemove(KeyHandle kh) {
        KeyHandleOffHeap handle = (KeyHandleOffHeap)kh;
        this.trackers.remove(handle.address(), handle.sequenceId());
    }

    @Override
    public long size() {
        return this.trackers.size();
    }

    @Override
    public TrackerMap.Cursor cursor() {
        return new CursorOffHeap();
    }

    @Override
    public void dispose() {
        this.trackers.dispose();
    }

    private class CursorOffHeap
    implements TrackerMap.Cursor,
    KeyHandleOffHeap {
        private final HashSlotCursor16byteKey c;
        private final TrackerOffHeap r;

        private CursorOffHeap() {
            this.c = TrackerMapOffHeap.this.trackers.cursor();
            this.r = new TrackerOffHeap();
        }

        @Override
        public boolean advance() {
            if (!this.c.advance()) {
                return false;
            }
            this.r.address = this.c.valueAddress();
            return true;
        }

        @Override
        public KeyHandleOffHeap asKeyHandle() {
            return this;
        }

        @Override
        public KeyHandle toKeyHandle() {
            return new SimpleHandleOffHeap(this.address(), this.sequenceId());
        }

        @Override
        public Tracker asTracker() {
            return this.r;
        }

        @Override
        public long address() {
            return this.c.key1();
        }

        @Override
        public long sequenceId() {
            return this.c.key2();
        }
    }
}

