/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.record;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.SortedBySeqRecordCursor;
import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import java.util.Arrays;
import java.util.List;

public class SortedBySeqRecordCursorOnHeap
implements SortedBySeqRecordCursor {
    private final List<KeyHandle> keyHandles;
    private final List<Record> records;
    private int position = -1;

    SortedBySeqRecordCursorOnHeap(List<KeyHandle> keyHandles, List<Record> records, MutatorCatchup mc) {
        assert (keyHandles.size() == records.size()) : "Handles and records sizes mismatch";
        int size = records.size();
        List<Record> recFrom = records;
        List<Record> recTo = Arrays.asList(new Record[size]);
        List<KeyHandle> khFrom = keyHandles;
        List<KeyHandle> khTo = Arrays.asList(new KeyHandle[size]);
        for (int width = 1; width < size; width *= 2) {
            for (int i = 0; i < size; i += 2 * width) {
                SortedBySeqRecordCursorOnHeap.bottomUpMerge(recFrom, khFrom, i, Math.min(i + width, size), Math.min(i + 2 * width, size), recTo, khTo, mc);
            }
            List<Record> fromBackup = recFrom;
            recFrom = recTo;
            recTo = fromBackup;
            List<KeyHandle> khFromBackup = khFrom;
            khFrom = khTo;
            khTo = khFromBackup;
        }
        this.keyHandles = khFrom;
        this.records = recFrom;
    }

    @Override
    public boolean advance() {
        if (this.position == this.records.size() - 1) {
            return false;
        }
        ++this.position;
        return true;
    }

    @Override
    public KeyHandle asKeyHandle() {
        assert (this.position >= 0) : "asKeyHandle() called on an invalid cursor";
        return this.keyHandles.get(this.position);
    }

    @Override
    public Record asRecord() {
        assert (this.position >= 0) : "asRecord() called on an invalid cursor";
        return this.records.get(this.position);
    }

    @Override
    public void dispose() {
    }

    private static void bottomUpMerge(List<Record> from, List<KeyHandle> khFrom, int leftStart, int rightStart, int rightEnd, List<Record> to, List<KeyHandle> khTo, MutatorCatchup mc) {
        int currLeft = leftStart;
        int currRight = rightStart;
        for (int i = leftStart; i < rightEnd; ++i) {
            if (currLeft < rightStart && (currRight >= rightEnd || from.get(currLeft).deadOrAliveSeq() <= from.get(currRight).deadOrAliveSeq())) {
                to.set(i, from.get(currLeft));
                khTo.set(i, khFrom.get(currLeft++));
            } else {
                to.set(i, from.get(currRight));
                khTo.set(i, khFrom.get(currRight++));
            }
            mc.catchupAsNeeded();
        }
    }
}

