/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.GrowingChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.nio.Disposable;

public abstract class Chunk
implements Disposable {
    public static final String SYSPROP_VAL_CHUNK_SIZE_LIMIT = "hazelcast.hotrestart.val.chunk.size.limit";
    public static final String SYSPROP_TOMB_CHUNK_SIZE_LIMIT = "hazelcast.hotrestart.tomb.chunk.size.limit";
    public static final int VAL_SIZE_LIMIT_DEFAULT = 0x800000;
    public static final int TOMB_SIZE_LIMIT_DEFAULT = 0x100000;
    public static final String FNAME_SUFFIX = ".chunk";
    public static final String ACTIVE_FNAME_SUFFIX = ".active";
    public static final String SURVIVOR_FNAME_SUFFIX = ".chunk.survivor";
    public static final String VAL_BASEDIR = "value";
    public static final String TOMB_BASEDIR = "tombstone";
    public final long seq;
    public final RecordMap records;
    public long garbage;
    public int liveRecordCount;
    private boolean needsDismissing;

    protected Chunk(long chunkSeq, RecordMap records) {
        this.seq = chunkSeq;
        this.records = records;
    }

    protected Chunk(GrowingChunk from) {
        this.seq = from.seq;
        this.records = from.records;
        this.liveRecordCount = from.liveRecordCount;
        this.garbage = from.garbage;
        this.needsDismissing = from.needsDismissing();
    }

    protected Chunk(long chunkSeq, RecordMap records, int liveRecordCount, long garbage) {
        this.seq = chunkSeq;
        this.records = records;
        this.liveRecordCount = liveRecordCount;
        this.garbage = garbage;
    }

    public final boolean needsDismissing() {
        return this.needsDismissing;
    }

    public void needsDismissing(boolean needsDismissing) {
        this.needsDismissing = needsDismissing;
    }

    public abstract long size();

    public void retire(KeyHandle kh, Record r, boolean mayIncrementGarbageCount) {
        assert (this.records.get(kh).liveSeq() == r.liveSeq()) : String.format("%s.retire(%s, %s) but have %s", this, kh, r, this.records.get(kh));
        this.garbage += (long)r.size();
        r.retire(mayIncrementGarbageCount);
        --this.liveRecordCount;
    }

    public void retire(KeyHandle kh, Record r) {
        this.retire(kh, r, true);
    }

    public String fnameSuffix() {
        return FNAME_SUFFIX;
    }

    public String base() {
        return VAL_BASEDIR;
    }

    @Override
    public void dispose() {
        this.records.dispose();
    }

    public static int valChunkSizeLimit() {
        return Integer.getInteger(SYSPROP_VAL_CHUNK_SIZE_LIMIT, 0x800000);
    }

    public static int tombChunkSizeLimit() {
        return Integer.getInteger(SYSPROP_TOMB_CHUNK_SIZE_LIMIT, 0x100000);
    }

    public String toString() {
        return String.format("%s(%03x,%,d,%,d)", this.getClass().getSimpleName(), this.seq, this.liveRecordCount, this.garbage);
    }
}

