/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterSerializerHook;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.UrgentSystemOperation;
import java.io.IOException;
import java.util.UUID;

public class GetClusterStateOperation
extends Operation
implements UrgentSystemOperation,
AllowedDuringPassiveState,
IdentifiedDataSerializable,
Versioned {
    private UUID senderUuid;
    private transient ClusterState response;

    public GetClusterStateOperation() {
    }

    public GetClusterStateOperation(UUID senderUuid) {
        this.senderUuid = senderUuid;
    }

    @Override
    public void run() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        this.response = nodeEngine.getClusterService().getClusterState();
        ClusterServiceImpl clusterService = (ClusterServiceImpl)nodeEngine.getClusterService();
        if (this.senderUuid != null && clusterService.isMaster() && this.isPersistenceEnabled(this.senderUuid)) {
            ((InternalPartitionService)this.getNodeEngine().getPartitionService()).resumeMigration();
            if (clusterService.getClusterJoinManager().hasMemberLeft(this.senderUuid)) {
                clusterService.getClusterJoinManager().removeLeftMember(this.senderUuid);
            }
        }
    }

    public ClusterState getResponse() {
        return this.response;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public int getFactoryId() {
        return HotRestartClusterSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        if (in.getVersion().isGreaterOrEqual(Versions.V5_0)) {
            this.senderUuid = UUIDSerializationUtil.readUUID(in);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_0)) {
            UUIDSerializationUtil.writeUUID(out, this.senderUuid);
        }
    }

    private boolean isPersistenceEnabled(UUID memberUuid) {
        MemberImpl member = this.getNodeEngine().getClusterService().getMember(memberUuid);
        if (member == null) {
            return false;
        }
        String persistenceEnabled = member.getAttribute("hazelcast.persistence.enabled");
        return "true".equals(persistenceEnabled);
    }
}

