/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.nio.IOUtil;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

abstract class AbstractMetadataWriter<T> {
    private static final String TMP_SUFFIX = ".tmp";
    private final File homeDir;

    AbstractMetadataWriter(File homeDir) {
        this.homeDir = homeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void write(T param) throws IOException {
        File tmpFile = new File(this.homeDir, this.getFilename() + TMP_SUFFIX);
        FileOutputStream fileOut = new FileOutputStream(tmpFile);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fileOut));
        try {
            this.doWrite(out, param);
            out.flush();
            fileOut.getFD().sync();
            out.close();
            IOUtil.rename(tmpFile, new File(this.homeDir, this.getFilename()));
            IOUtil.fsyncDir(this.homeDir.toPath());
        }
        finally {
            IOUtil.closeResource(out);
        }
    }

    abstract String getFilename();

    abstract void doWrite(DataOutput var1, T var2) throws IOException;

    static void writeAddress(DataOutput out, Address address) throws IOException {
        out.writeUTF(address.getHost());
        out.writeInt(address.getPort());
    }
}

