/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.LongIterator;
import com.hazelcast.internal.elastic.queue.LongBlockingQueue;
import com.hazelcast.internal.elastic.queue.LongConsumer;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class LongArrayBlockingQueue
implements LongBlockingQueue {
    private static final long ENTRY_SIZE = 8L;
    private final MemoryAllocator malloc;
    private final int capacity;
    private final long address;
    private final long nullItem;
    private int add;
    private int remove;
    private int size;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public LongArrayBlockingQueue(MemoryAllocator memoryAllocator, int capacity, long nullItem) {
        this.malloc = memoryAllocator;
        this.capacity = capacity;
        this.nullItem = nullItem;
        long realCap = (long)capacity * 8L;
        this.address = this.malloc.allocate(realCap);
        this.clear();
    }

    private long get(int index) {
        if (index >= this.capacity || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.address + (long)index * 8L);
    }

    private void set(int index, long value) {
        if (index >= this.capacity || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.address + (long)index * 8L, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(long value) {
        if (value == this.nullItem) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.size != this.capacity && this.insert(value);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(long value, long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(long value) throws InterruptedException {
        if (value == this.nullItem) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.size == this.capacity) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException ie) {
                this.notFull.signal();
                throw ie;
            }
            this.insert(value);
        }
        finally {
            lock.unlock();
        }
    }

    private boolean insert(long value) {
        this.ensureMemory();
        this.set(this.add, value);
        ++this.add;
        ++this.size;
        if (this.add == this.capacity) {
            this.add = 0;
        }
        this.notEmpty.signal();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.ensureMemory();
            if (this.size == 0) {
                long l = this.nullItem;
                return l;
            }
            long l = this.get(this.remove);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size == 0) {
                long l = this.nullItem;
                return l;
            }
            long l = this.extract();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long poll(long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.size == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            long l = this.extract();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    private long extract() {
        this.ensureMemory();
        long value = this.get(this.remove);
        this.set(this.remove, this.nullItem);
        ++this.remove;
        --this.size;
        if (this.remove == this.capacity) {
            this.remove = 0;
        }
        this.notFull.signal();
        return value;
    }

    private void ensureMemory() {
        if (this.size < 0) {
            throw new IllegalStateException("Queue is already destroyed! " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(LongConsumer consumer) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            while (this.size > 0) {
                long value = this.get(this.remove);
                if (!consumer.consume(value)) continue;
                this.set(this.remove, this.nullItem);
                ++this.remove;
                --this.size;
                if (this.remove != this.capacity) continue;
                this.remove = 0;
            }
            this.notFull.signal();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.capacity - this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            GlobalMemoryAccessorRegistry.AMEM.setMemory(this.address, (long)this.capacity * 8L, (byte)0);
            this.add = 0;
            this.remove = 0;
            this.size = 0;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void dispose() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size > -1) {
                this.malloc.free(this.address, (long)this.capacity * 8L);
                this.add = 0;
                this.remove = 0;
                this.size = -1;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public long nullItem() {
        return this.nullItem;
    }

    @Override
    public LongIterator iterator() {
        this.lock.lock();
        try {
            this.ensureMemory();
            Iter iter2 = new Iter();
            return iter2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "LongArrayBlockingQueue{capacity=" + this.capacity + ", address=" + this.address + ", size=" + this.size() + "}";
    }

    private class Iter
    implements LongIterator {
        private int remaining;
        private int nextIndex;
        private long nextItem;

        Iter() {
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            ReentrantLock lock = LongArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                LongArrayBlockingQueue.this.ensureMemory();
                long item = this.nextItem;
                while (--this.remaining > 0) {
                    this.nextIndex = this.inc(this.nextIndex);
                    this.nextItem = LongArrayBlockingQueue.this.get(this.nextIndex);
                    if (this.nextItem == LongArrayBlockingQueue.this.nullItem) continue;
                }
                long l = item;
                return l;
            }
            finally {
                lock.unlock();
            }
        }

        private int inc(int i) {
            int next = i + 1;
            return next == LongArrayBlockingQueue.this.capacity ? 0 : next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.remaining = LongArrayBlockingQueue.this.size;
            if (this.remaining > 0) {
                this.nextIndex = LongArrayBlockingQueue.this.remove;
                this.nextItem = LongArrayBlockingQueue.this.get(this.nextIndex);
            }
        }
    }
}

