/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.diagnostics.OperationProfilerPlugin;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.TimeUnit;

public class InvocationProfilerPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.invocation-profiler.period.seconds", 5, TimeUnit.SECONDS);
    private final InvocationRegistry invocationRegistry;
    private long periodMs;
    private final HazelcastProperties properties;

    public InvocationProfilerPlugin(ILogger logger, InvocationRegistry invocationRegistry, HazelcastProperties props) {
        super(logger);
        this.invocationRegistry = invocationRegistry;
        this.properties = props;
        this.readProperties();
    }

    @Override
    void readProperties() {
        this.periodMs = this.properties.getMillis(this.overrideProperty(PERIOD_SECONDS));
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMs;
    }

    @Override
    public void onStart() {
        this.periodMs = this.properties.getMillis(this.overrideProperty(PERIOD_SECONDS));
        super.onStart();
        this.logger.info("Plugin:active: period-millis:" + this.periodMs);
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        this.logger.info("Plugin:inactive: period-millis:" + this.periodMs);
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        if (!this.isActive()) {
            return;
        }
        writer.startSection("InvocationProfiler");
        OperationProfilerPlugin.write(writer, this.invocationRegistry.latencyDistributions());
        writer.endSection();
    }
}

