/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.diagnostics.HealthMonitor;
import com.hazelcast.internal.metrics.LongGauge;
import com.hazelcast.vector.impl.VectorCollectionService;

public class EnterpriseHealthMonitor
extends HealthMonitor {
    public EnterpriseHealthMonitor(Node node) {
        super(node);
        this.healthMetrics = new EnterpriseHealthMetrics();
    }

    private boolean isVectorCollectionEnabled() {
        VectorCollectionService maybeService = (VectorCollectionService)this.node.getNodeEngine().getServiceOrNull("hz:service:vector");
        return maybeService != null && maybeService.isEnabled();
    }

    class EnterpriseHealthMetrics
    extends HealthMonitor.HealthMetrics {
        final LongGauge executorVectorQueryQueueSize;

        EnterpriseHealthMetrics() {
            super(EnterpriseHealthMonitor.this);
            this.executorVectorQueryQueueSize = EnterpriseHealthMonitor.this.metricRegistry.newLongGauge("executor.hz:vector-query.queueSize");
        }

        @Override
        void renderExecutors() {
            super.renderExecutors();
            if (EnterpriseHealthMonitor.this.isVectorCollectionEnabled()) {
                this.sb.append("executor.q.vector.query.size=").append(this.executorVectorQueryQueueSize.read()).append(", ");
            }
        }
    }
}

