/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.util;

import com.hazelcast.internal.config.util.XmlConfigBuilderParser;
import com.hazelcast.internal.util.XmlUtil;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.api.Dump;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.api.DumpSettings;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.api.Load;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.api.LoadSettings;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.api.LoadSettingsBuilder;
import com.hazelcast.shaded.org.snakeyaml.engine.v2.common.FlowStyle;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigDataMaskingUtil {
    public static final String MASK_FOR_SENSITIVE_DATA = "****";
    private static final String PASSWORD_ATTRIBUTE = "password";
    private static final Set<String> MASKED_KEYS = new HashSet<String>();

    private ConfigDataMaskingUtil() {
    }

    private static boolean isXMLFormat(String configString) {
        if (configString == null) {
            return false;
        }
        String trimmed = configString.trim();
        return trimmed.startsWith("<");
    }

    public static String maskSensitiveData(String configString) throws Exception {
        if (ConfigDataMaskingUtil.isXMLFormat(configString)) {
            return ConfigDataMaskingUtil.maskSensitiveXml(configString);
        }
        return ConfigDataMaskingUtil.maskSensitiveYaml(configString);
    }

    private static String maskSensitiveYaml(String configString) {
        LoadSettingsBuilder builder = LoadSettings.builder();
        LoadSettings loadSettings = builder.build();
        Load load = new Load(loadSettings);
        Object data = load.loadFromString(configString);
        Map document = (Map)data;
        ConfigDataMaskingUtil.maskSensitiveDataInMap(data);
        DumpSettings dumpSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).build();
        Dump dump = new Dump(dumpSettings);
        return dump.dumpToString(document);
    }

    private static String maskSensitiveXml(String configString) throws Exception {
        ByteArrayInputStream configStream = new ByteArrayInputStream(configString.getBytes(StandardCharsets.UTF_8));
        XmlConfigBuilderParser configBuilder = new XmlConfigBuilderParser(configStream);
        Document document = configBuilder.parseStream();
        NodeList nodes = document.getElementsByTagName("*");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            if (ConfigDataMaskingUtil.isSensitivePropertyName(element.getNodeName())) {
                element.setTextContent(MASK_FOR_SENSITIVE_DATA);
            }
            if (!element.hasAttributes()) continue;
            NamedNodeMap attributes = element.getAttributes();
            for (int a2 = 0; a2 < attributes.getLength(); ++a2) {
                Node attr = attributes.item(a2);
                if (attr.getNodeName().toLowerCase().contains(PASSWORD_ATTRIBUTE)) {
                    attr.setNodeValue(MASK_FOR_SENSITIVE_DATA);
                }
                if (!element.getNodeName().equalsIgnoreCase("property") && !element.getNodeName().equalsIgnoreCase("attribute") || !ConfigDataMaskingUtil.isSensitivePropertyName(attr.getNodeValue().toLowerCase())) continue;
                element.setTextContent(MASK_FOR_SENSITIVE_DATA);
            }
        }
        TransformerFactory transformerFactory = XmlUtil.getTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    private static void maskSensitiveDataInMap(Object data) {
        block6: {
            block5: {
                if (!(data instanceof Map)) break block5;
                Map map = (Map)data;
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (ConfigDataMaskingUtil.isSensitivePropertyName((String)entry.getKey())) {
                        if (((String)entry.getKey()).equalsIgnoreCase("token")) {
                            ConfigDataMaskingUtil.maskTokenKeyInYaml(entry);
                            continue;
                        }
                        map.put(entry.getKey(), MASK_FOR_SENSITIVE_DATA);
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("member-attributes")) {
                        ConfigDataMaskingUtil.maskSensitiveMemberAttributesInYaml(entry);
                        continue;
                    }
                    ConfigDataMaskingUtil.maskSensitiveDataInMap(entry.getValue());
                }
                break block6;
            }
            if (!(data instanceof List)) break block6;
            List list = (List)data;
            for (Object e : list) {
                ConfigDataMaskingUtil.maskSensitiveDataInMap(e);
            }
        }
    }

    private static void maskTokenKeyInYaml(Map.Entry<String, Object> entry) {
        if (entry.getValue() instanceof Map) {
            Map tokenMap = (Map)entry.getValue();
            if (tokenMap.containsKey("value")) {
                tokenMap.put("value", MASK_FOR_SENSITIVE_DATA);
            }
        } else {
            entry.setValue(MASK_FOR_SENSITIVE_DATA);
        }
    }

    private static void maskSensitiveMemberAttributesInYaml(Map.Entry<String, Object> entry) {
        if (entry.getValue() instanceof Map) {
            Map attributes = (Map)entry.getValue();
            for (Map.Entry attribute : attributes.entrySet()) {
                if (!ConfigDataMaskingUtil.isSensitivePropertyName((String)attribute.getKey())) continue;
                Map attributeValue = (Map)attribute.getValue();
                attributeValue.put("value", MASK_FOR_SENSITIVE_DATA);
            }
        }
    }

    private static boolean isSensitivePropertyName(String value) {
        for (String word : MASKED_KEYS) {
            if (!value.toLowerCase().contains(word)) continue;
            return true;
        }
        return false;
    }

    static {
        MASKED_KEYS.add("license-key");
        MASKED_KEYS.add(PASSWORD_ATTRIBUTE);
        MASKED_KEYS.add("token");
        MASKED_KEYS.add("salt");
        MASKED_KEYS.add("access-key");
        MASKED_KEYS.add("secret-key");
        MASKED_KEYS.add("client-id");
        MASKED_KEYS.add("client-secret");
        MASKED_KEYS.add("tenant-id");
    }
}

