/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.PartitionTStoreBTreeCompactor;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.bplustree.TStoreBTreeCompactor;
import com.hazelcast.internal.bplustree.TStoreBTreeCompactorConstructorFn;
import com.hazelcast.internal.memory.AbstractPoolingMemoryManager;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.IndexAllocator;
import com.hazelcast.internal.memory.MemoryAddressTranslator;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.RecordPool;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.LogBasedCompactor;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.PinType;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.internal.util.MutableLong;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TStoreBTreeAllocator
implements IndexAllocator,
TStoreAllocator {
    public static final long BTREE_RETRY_RAW_STATUS = -1L;
    private static final long NULL = 0L;
    private static final int PRE_ALLOCATED_NODES = 32;
    private final int nodeSize;
    private final HybridLogImpl treeLog;
    private final Dependencies dependencies;
    private final AbstractPoolingMemoryManager.MetadataMemoryAllocator metadataAllocator;
    private final RecordPool nodes;
    private final SlotAccessor slotAccessor;
    private final AtomicBoolean disposed = new AtomicBoolean();

    public TStoreBTreeAllocator(LibMalloc malloc, PooledNativeMemoryStats memoryStats, int nodeSize, HybridLog treeLog, Dependencies dependencies) {
        this.nodeSize = nodeSize;
        this.treeLog = (HybridLogImpl)treeLog;
        this.dependencies = dependencies;
        this.metadataAllocator = new AbstractPoolingMemoryManager.MetadataMemoryAllocator(malloc, memoryStats);
        this.nodes = new RecordPool(this.metadataAllocator, RecordPool.Mode.NUMBERS, 16, 32);
        this.slotAccessor = new SlotAccessor(nodeSize);
    }

    @Override
    public int getNodeSize() {
        return this.nodeSize;
    }

    @Override
    public long allocate(long size) {
        assert (size == (long)this.nodeSize);
        long stableAddress = this.nodes.acquire();
        assert (stableAddress > 0L);
        return stableAddress;
    }

    @Override
    public void allocateLogical(long stableAddress, LockingContext lockingContext) {
        long logicalAddress = this.perform(Operation.ALLOCATE, stableAddress, false, lockingContext);
        assert (this.treeLog.isMutable(logicalAddress));
        int currentThreadIndex = this.treeLog.getEpoch().getCurrentThreadIndex();
        long physicalAddress = this.treeLog.asPhysicalAddress(logicalAddress, currentThreadIndex);
        assert (physicalAddress > 0L);
        TStoreBTreeAllocator.write(physicalAddress, stableAddress);
    }

    @Override
    public long reallocate(long stableAddress, long currentSize, long newSize) {
        assert (stableAddress > 0L);
        assert (currentSize == (long)this.nodeSize);
        assert (currentSize == newSize);
        return stableAddress;
    }

    @Override
    public void free(long stableAddress, long size) {
        assert (stableAddress > 0L);
        assert (size == (long)this.nodeSize);
        this.nodes.release(stableAddress);
    }

    @Override
    public int getKeyPartition(Data key) {
        return this.dependencies.getPartition(key);
    }

    @Override
    public boolean isAllocated(long stableAddress) {
        return this.nodes.isAcquired(stableAddress);
    }

    @Override
    public long translateToLogical(long stableAddress, LockingContext lockingContext) {
        assert (stableAddress > 0L) : stableAddress;
        long logicalAddress = lockingContext.resolvePinned(stableAddress);
        if (logicalAddress == 0L) {
            logicalAddress = TStoreBTreeAllocator.read(this.nodes.addressOf(stableAddress));
        }
        assert (logicalAddress > 0L) : stableAddress + " " + logicalAddress;
        return logicalAddress;
    }

    @Override
    public long translateToPhysical(long stableAddress, LockingContext lockingContext) {
        long logicalAddress = this.translateToLogical(stableAddress, lockingContext);
        long physicalAddress = this.treeLog.asPhysicalAddress(logicalAddress, Integer.MIN_VALUE);
        assert (physicalAddress > 0L) : String.format("Invalid physical address 0x0%s resolved for %s", Long.toHexString(physicalAddress), this.treeLog.prettyFormat(logicalAddress));
        return physicalAddress;
    }

    @Override
    public long getLockAddress(long stableAddress) {
        assert (stableAddress > 0L);
        return this.nodes.addressOf(stableAddress) + 8L;
    }

    @Override
    public long tryLockRecord(int partition, long keyHash) {
        int threadIndex = this.treeLog.getEpoch().getCurrentThreadIndex();
        State state = this.dependencies.getState(partition);
        state.refresh(threadIndex);
        Index index = this.dependencies.getIndex(partition);
        return index.tryLock(threadIndex, keyHash);
    }

    @Override
    public void waitUntilRecordUnlocked(int partition, long keyHash, long cookie) {
        Index index = this.dependencies.getIndex(partition);
        index.waitUntilUnlocked(this.treeLog.getEpoch().getCurrentThreadIndex(), keyHash, cookie);
    }

    @Override
    public void unlockRecord(int partition, long keyHash, long cookie) {
        Index index = this.dependencies.getIndex(partition);
        index.unlock(keyHash, cookie);
    }

    @Override
    public Data getRecordValue(int partition, Data key) {
        int threadIndex = this.treeLog.getEpoch().getCurrentThreadIndex();
        Index index = this.dependencies.getIndex(partition);
        long record = index.getRaw(threadIndex, key, -1L, false);
        if (record == -1L) {
            return TStoreAllocator.RETRY;
        }
        if (record == 0L) {
            return null;
        }
        return this.dependencies.getRecordValue(partition, key, record);
    }

    @Override
    public void yield(int partition) {
        int threadPhase;
        int threadIndex = this.treeLog.getEpoch().getCurrentThreadIndex();
        State state = this.dependencies.getState(partition);
        do {
            Thread.yield();
            this.treeLog.getEpoch().refresh(threadIndex);
        } while ((threadPhase = State.phase(state.refresh(threadIndex))) != 0);
    }

    @Override
    public void pinAndReplaceLastUnpinned(long stableAddress, LockingContext lockingContext) {
        long replaced = lockingContext.replaceAddressToPin(stableAddress);
        if (replaced == 0L) {
            return;
        }
        boolean mutable = replaced < 0L;
        long stablePinAddress = Math.abs(replaced);
        this.perform(mutable ? Operation.WRITE : Operation.READ, stablePinAddress, true, lockingContext);
    }

    @Override
    public void unpinIfNotLastUnpinned(long stableAddress, LockingContext lockingContext) {
        long consumed = lockingContext.consumeAddressToUnpin(stableAddress);
        if (consumed == 0L) {
            return;
        }
        long logicalAddress = this.translateToLogicalPinned(consumed, lockingContext);
        PinType pinType = lockingContext.resolvePinType(stableAddress);
        this.treeLog.unpinAddress(logicalAddress, pinType);
        lockingContext.removePin(consumed);
    }

    @Override
    public void unpin(long stableAddress, LockingContext lockingContext) {
        long logicalAddress = this.translateToLogicalPinned(stableAddress, lockingContext);
        PinType pinType = lockingContext.resolvePinType(stableAddress);
        this.treeLog.unpinAddress(logicalAddress, pinType);
    }

    @Override
    public void ensureReadable(long stableAddress, LockingContext lockingContext) {
        this.perform(Operation.READ, stableAddress, false, lockingContext);
    }

    @Override
    public void ensureWritable(long stableAddress, LockingContext lockingContext) {
        this.perform(Operation.WRITE, stableAddress, false, lockingContext);
    }

    @Override
    public void upgradeToWritable(long stableAddress, LockingContext lockingContext) {
        if (lockingContext.isPinned(stableAddress)) {
            PinType pinType = lockingContext.resolvePinType(stableAddress);
            this.treeLog.unpinAddress(this.translateToLogicalPinned(stableAddress, lockingContext), pinType);
            lockingContext.removePin(stableAddress);
            this.pinAndReplaceLastUnpinned(-stableAddress, lockingContext);
        } else {
            long replaced = lockingContext.replaceAddressToPin(-stableAddress);
            assert (stableAddress == Math.abs(replaced));
        }
        this.ensureWritable(stableAddress, lockingContext);
    }

    @Override
    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        this.nodes.close();
        this.metadataAllocator.dispose();
        Epoch epoch = this.treeLog.getEpoch();
        int currentThreadIndex = epoch.getCurrentThreadIndex();
        epoch.bump(currentThreadIndex, (threadIndex, actionEpoch) -> this.treeLog.dispose());
    }

    @Override
    public List<Long> getNodeAddressesFromFreeQueue() {
        throw new UnsupportedOperationException();
    }

    private void unpinWritePins(LockingContext lockingContext) {
        lockingContext.stashPins(logical -> {
            if (logical < 0L) {
                this.treeLog.unpinAddress(-logical, PinType.WRITE);
                return true;
            }
            return false;
        });
    }

    private void repinWritePins(LockingContext lockingContext) {
        lockingContext.unstashPins(stable -> {
            long address = this.nodes.addressOf(stable);
            long logical = this.tryLoad(stable, address, true, lockingContext);
            if (logical == 0L) {
                this.unpinWritePins(lockingContext);
                this.treeLog.getEpoch().refresh(this.treeLog.getEpoch().getCurrentThreadIndex());
                return false;
            }
            if (!this.treeLog.pinAddress(logical, PinType.WRITE)) {
                this.unpinWritePins(lockingContext);
                this.treeLog.getEpoch().refresh(this.treeLog.getEpoch().getCurrentThreadIndex());
                return false;
            }
            lockingContext.addPin(stable, -logical);
            return true;
        });
    }

    private long perform(Operation operation, long stable, boolean pin, LockingContext lockingContext) {
        long logical;
        long address = this.nodes.addressOf(stable);
        boolean mutable = operation != Operation.READ;
        boolean didUnpin = false;
        while (true) {
            switch (operation) {
                case ALLOCATE: {
                    logical = this.tryAllocate(stable, address);
                    if (logical == 0L) break;
                    operation = Operation.WRITE;
                    break;
                }
                case READ: 
                case WRITE: {
                    logical = this.tryLoad(stable, address, mutable, lockingContext);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (logical == 0L) {
                if (!didUnpin) {
                    this.unpinWritePins(lockingContext);
                    didUnpin = true;
                }
                this.treeLog.getEpoch().refresh(this.treeLog.getEpoch().getCurrentThreadIndex());
                continue;
            }
            if (!pin && !didUnpin || this.tryPin(stable, logical, mutable, lockingContext)) break;
            if (!didUnpin) {
                this.unpinWritePins(lockingContext);
                didUnpin = true;
            }
            this.treeLog.getEpoch().refresh(this.treeLog.getEpoch().getCurrentThreadIndex());
        }
        if (didUnpin) {
            this.repinWritePins(lockingContext);
            if (!pin) {
                this.treeLog.unpinAddress(logical, mutable ? PinType.WRITE : PinType.READ);
                lockingContext.removePin(stable);
            }
        }
        return logical;
    }

    private long tryLoad(long stable, long address, boolean mutable, LockingContext lockingContext) {
        long logical = this.translateToLogicalUnpinned(stable, address, lockingContext);
        if (this.treeLog.isInMemory(logical) && !mutable || this.treeLog.isMutable(logical)) {
            return logical;
        }
        MutableLong box = new MutableLong();
        box.value = logical;
        Boolean status = mutable ? this.treeLog.readRecordForUpdate(logical, this.slotAccessor, (record, oldLogical, newLogical, threadIndex) -> {
            box.value = newLogical;
            return newLogical;
        }) : this.treeLog.readRecordForReadOnly(logical, this.slotAccessor, (record, oldLogical, newLogical, threadIndex) -> {
            box.value = newLogical;
            return newLogical;
        });
        assert (status != null);
        if (status == Boolean.FALSE) {
            return 0L;
        }
        long newLogical2 = box.value;
        if (newLogical2 != logical) {
            TStoreBTreeAllocator.cas(address, logical, newLogical2);
        }
        return newLogical2;
    }

    private long tryAllocate(long stable, long address) {
        long logical = this.treeLog.tryAllocate(this.nodeSize);
        assert (logical != 0L);
        if (logical < 0L) {
            return 0L;
        }
        TStoreBTreeAllocator.write(address, logical);
        int currentThreadIndex = this.treeLog.getEpoch().getCurrentThreadIndex();
        long physical = this.treeLog.asPhysicalAddress(logical, currentThreadIndex);
        assert (physical > 0L);
        TStoreBTreeAllocator.write(physical, stable);
        return logical;
    }

    private boolean tryPin(long stable, long logical, boolean mutable, LockingContext lockingContext) {
        if (mutable) {
            if (this.treeLog.pinAddress(logical, PinType.WRITE)) {
                lockingContext.addPin(stable, -logical);
                return true;
            }
        } else if (this.treeLog.pinAddress(logical, PinType.READ)) {
            lockingContext.addPin(stable, logical);
            return true;
        }
        return false;
    }

    private long translateToLogicalUnpinned(long stable, long address, LockingContext lockingContext) {
        assert (stable > 0L) : stable;
        assert (lockingContext.resolvePinned(stable) == 0L);
        long logical = TStoreBTreeAllocator.read(address);
        assert (logical > 0L) : stable + " " + logical;
        return logical;
    }

    private long translateToLogicalPinned(long stableAddress, LockingContext lockingContext) {
        assert (stableAddress > 0L) : stableAddress;
        long logicalAddress = lockingContext.resolvePinned(stableAddress);
        assert (logicalAddress > 0L) : stableAddress + " " + logicalAddress;
        return logicalAddress;
    }

    private static long read(long address) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(address);
    }

    private static void write(long address, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(address, value);
    }

    private static void cas(long address, long expected, long value) {
        GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(address, expected, value);
    }

    @Override
    public void registerEpoch() {
        this.treeLog.getEpoch().register();
    }

    @Override
    public void unregisterEpoch() {
        int threadIndex = this.treeLog.getEpoch().getCurrentThreadIndex();
        this.treeLog.getEpoch().unregister(threadIndex);
    }

    @Override
    public void pauseEpoch() {
        this.treeLog.getEpoch().pause(this.treeLog.getEpoch().getCurrentThreadIndex());
    }

    @Override
    public void resumeEpoch() {
        this.treeLog.getEpoch().resume(this.treeLog.getEpoch().getCurrentThreadIndex());
    }

    @Override
    public void registerState(int partitionId) {
        int threadIndex = this.treeLog.getEpoch().getCurrentThreadIndex();
        this.dependencies.getState(partitionId).register(threadIndex);
    }

    @Override
    public void unregisterState(int partitionId) {
        int threadIndex = this.treeLog.getEpoch().getCurrentThreadIndex();
        this.dependencies.getState(partitionId).unregister(threadIndex);
    }

    @Override
    public PartitionIdSet newPartitionIdSet() {
        return this.dependencies.newPartitionIdSet();
    }

    @Override
    public void registerCompactor(TStoreBTreeCompactor.Dependencies compactorDependencies) {
        if (!this.shouldUseGlobalIndex()) {
            throw new IllegalStateException("Partitioned indexes use partition-based compactor");
        }
        TStoreUserId userId = this.treeLog.getDevice().userId();
        HazelcastProperties properties = this.dependencies.getProperties();
        TStoreBTreeCompactorConstructorFn constructorFn = new TStoreBTreeCompactorConstructorFn(this.getNodeSize(), this.treeLog, this.treeLog.getEpoch(), compactorDependencies, properties);
        this.dependencies.getCompactionManager().addCompactorConstructorFn(userId, 0, constructorFn);
    }

    @Override
    public LogBasedCompactor<?> newPartitionCompactor(int segmentNo, TStoreBTreeCompactor.Dependencies compactorDependencies) {
        HazelcastProperties properties = this.dependencies.getProperties();
        return new PartitionTStoreBTreeCompactor(this.nodeSize, this.treeLog, this.treeLog.getEpoch(), compactorDependencies, segmentNo, properties);
    }

    @Override
    public HybridLog getHybridLog() {
        return this.treeLog;
    }

    @Override
    public boolean shouldUseGlobalIndex() {
        return this.dependencies.shouldUseGlobalIndex();
    }

    @Override
    public long addressOf(long address) {
        return this.nodes.addressOf(address);
    }

    @Override
    public long nodeFromAddress(long address) {
        return this.nodes.recordOf(address);
    }

    public static interface Dependencies {
        public int getPartition(Data var1);

        public State getState(int var1);

        public Index getIndex(int var1);

        public Data getRecordValue(int var1, Data var2, long var3);

        public PartitionIdSet newPartitionIdSet();

        public CompactionManager getCompactionManager();

        public HazelcastProperties getProperties();

        public boolean shouldUseGlobalIndex();
    }

    private record SlotAccessor(int nodeSize) implements InMemorySlotAccessor<Void, Boolean>
    {
        @Override
        public Void prepare(long slotLogicalAddress, MemoryAddressTranslator translator, int threadIndex) {
            return null;
        }

        @Override
        public int size(Void preparedSlot) {
            return this.nodeSize;
        }

        @Override
        public boolean isAlive(Void preparedSlot) {
            return true;
        }

        @Override
        public Boolean asEntry(Void preparedSlot) {
            return Boolean.TRUE;
        }

        @Override
        public boolean lock(Void preparedSlot) {
            return true;
        }

        @Override
        public void unlock(Void preparedSlot) {
        }

        @Override
        public Boolean retryStatus() {
            return Boolean.FALSE;
        }

        @Override
        public long retryRawStatus() {
            return -1L;
        }

        @Override
        public int headerSize() {
            return 0;
        }

        @Override
        public Data readValue(byte[] record) {
            return null;
        }

        @Override
        public int length(byte[] chunkPart) {
            return this.nodeSize;
        }
    }

    private static enum Operation {
        ALLOCATE,
        READ,
        WRITE;

    }
}

