/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class RuVersionHelper {
    private RuVersionHelper() {
    }

    public static Set<Version> buildSupportedVersions(BuildInfo buildInfo, Version currentVersion, boolean includeLts) {
        ArrayList<Version> versions = new ArrayList<Version>();
        RuVersionHelper.addBaseCompatibleVersions(versions, currentVersion);
        RuVersionHelper.addSpecialVersionHandling(versions, currentVersion);
        if (includeLts) {
            RuVersionHelper.addLtsVersions(buildInfo, versions);
        }
        return CollectionUtil.setOf(versions.toArray(new Version[0]));
    }

    private static void addBaseCompatibleVersions(List<Version> versions, Version currentVersion) {
        versions.add(currentVersion);
        versions.add(currentVersion.previousMinor());
    }

    private static void addSpecialVersionHandling(List<Version> versions, Version currentVersion) {
        if (currentVersion.equals(Versions.V5_6)) {
            versions.add(Versions.V5_3);
            versions.add(Versions.V5_4);
            versions.add(Versions.V5_5);
        }
    }

    private static void addLtsVersions(BuildInfo buildInfo, List<Version> versions) {
        Version lastLts = buildInfo.getLastLtsVersion().asVersion();
        if (lastLts.equals(Versions.V5_5)) {
            versions.add(Versions.V5_6);
        }
        versions.add(lastLts);
    }
}

