/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.util.LicenseHelper;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.Capacity;
import com.hazelcast.replicatedmap.ReplicatedMap;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class LicenseMemoryChecker {
    public static final String TS_MEM_STATS_MAP = "__ts.memstats_cEowxHI2YqGjvz3IlErNrRInk9xMG3Mi";
    static final double SOFT_MEMORY_EXCEEDING_LIMIT = 0.8;
    static final double HARD_MEMORY_EXCEEDING_LIMIT = 0.9;
    static final int SOFT_MEMORY_EXCEEDING_LIMIT_PERCENT = 80;
    static final int HARD_MEMORY_EXCEEDING_LIMIT_PERCENT = 90;
    private static final String CLUSTER = "cluster";
    private static final String MEMBER = "member";
    private static final String TS = "Tiered Storage";
    private static final String HD = "HD";
    private static final String MEMORY_CLOSE_TO_LIMITS_MESSAGE_TEMPLATE = "The %s is at %d percent capacity of the %s licensed memory limit. Consider removing some data to avoid a license breach or contacting support to increase the licensed memory limit. ";
    private static final String HD_MEMORY_LICENSE_BREACH_MESSAGE = "The member has exceeded the HD licensed memory limit.";
    private static final String TS_MEMORY_LICENSE_BREACH_MESSAGE = "The cluster has exceeded the Tiered Storage licensed memory limit.";
    private static final String TS_LOCAL_DEVICE_CAPACITY_EXCEED_LICENSE_LIMIT_MESSAGE = "The dynamically configured cluster-wide tiered store device capacity: %s exceeds licensed memory limit: %s";
    private static final int UNLIMITED_TIERED_STORE_SIZE = 99999;
    private static final int SOFT_LIMIT_BIT = 0;
    private static final int HARD_LIMIT_BIT = 1;
    private static final int LICENSE_BREACH_BIT = 2;
    private static final int MEMORY_LIMIT_CHECKS_FOR_INFO_LOG = 5;
    private static final long BYTES_IN_GB = 0x40000000L;
    static final long HD_RECOMMENDED_LIMIT_200GB = 0x3200000000L;
    private final EnterpriseNodeExtension nodeExtension;
    private final Node node;
    private final ILogger logger;
    private ReplicatedMap<UUID, Long> tsMemoryStats;
    private final BitSet hdMemoryLimitFlags = new BitSet(3);
    private final BitSet tsMemoryLimitFlags = new BitSet(3);
    private int hdLicenseCheckRepetitions;
    private int tsLicenseCheckRepetitions;
    private volatile long maxTSMemoryConsumption;

    public LicenseMemoryChecker(EnterpriseNodeExtension nodeExtension) {
        this.nodeExtension = nodeExtension;
        this.node = nodeExtension.node;
        this.logger = this.node.getLogger(LicenseMemoryChecker.class);
    }

    public void checkLicensedFeaturesMemoryLimit(Feature feature) {
        int licenseCheckInterval = this.node.getProperties().getInteger(EnterpriseNodeExtension.LICENSE_CHECK_INTERVAL_IN_SECONDS);
        if (licenseCheckInterval > EnterpriseNodeExtension.MAX_LICENSE_CHECK_INTERVAL_IN_SECONDS) {
            throw new InvalidConfigurationException("License check interval is an internal property used for testing and shouldn't be changed.");
        }
        switch (feature) {
            case HD_MEMORY: {
                this.launchHDMemorySizeLimitCheck(licenseCheckInterval);
                break;
            }
            case TIERED_STORAGE: {
                this.launchTieredStoreSizeLimitCheck(licenseCheckInterval);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown feature: " + String.valueOf(feature));
            }
        }
    }

    void launchHDMemorySizeLimitCheck(int licenseCheckInterval) {
        if (LicenseHelper.isBuiltInLicense(this.nodeExtension.getLicense())) {
            return;
        }
        this.node.nodeEngine.getExecutionService().getGlobalTaskScheduler().scheduleWithRepetition(() -> {
            if (this.node.isLiteMember()) {
                return;
            }
            this.loopHDLicenseCheckRepetitions();
            License license = this.nodeExtension.getLicense();
            MemoryStats memoryStats = this.nodeExtension.getMemoryStats();
            long hdMemoryLimitInBytes = (long)license.getAllowedNativeMemorySize() * 0x40000000L;
            long softLimit = (long)((double)hdMemoryLimitInBytes * 0.8);
            long hardLimit = (long)((double)hdMemoryLimitInBytes * 0.9);
            long usedMemory = memoryStats.getUsedNative();
            if (usedMemory >= hdMemoryLimitInBytes) {
                this.setMemoryUsageBits(this.hdMemoryLimitFlags, 0, 1, 2);
                this.logger.warning(HD_MEMORY_LICENSE_BREACH_MESSAGE);
            } else if (usedMemory >= hardLimit) {
                this.setMemoryUsageBits(this.hdMemoryLimitFlags, 0, 1);
                this.clearMemoryUsageBits(this.hdMemoryLimitFlags, 2);
                this.logger.warning(String.format(MEMORY_CLOSE_TO_LIMITS_MESSAGE_TEMPLATE, MEMBER, 90, HD));
            } else if (usedMemory >= softLimit) {
                this.setMemoryUsageBits(this.hdMemoryLimitFlags, 0);
                this.clearMemoryUsageBits(this.hdMemoryLimitFlags, 1, 2);
                if (this.hdLicenseCheckRepetitions == 0) {
                    this.logger.info(String.format(MEMORY_CLOSE_TO_LIMITS_MESSAGE_TEMPLATE, MEMBER, 80, HD));
                }
            } else {
                this.hdMemoryLimitFlags.clear();
            }
            ++this.hdLicenseCheckRepetitions;
        }, licenseCheckInterval, licenseCheckInterval, TimeUnit.SECONDS);
    }

    void launchTieredStoreSizeLimitCheck(int licenseCheckInterval) {
        if (LicenseHelper.isBuiltInLicense(this.nodeExtension.getLicense())) {
            return;
        }
        this.node.nodeEngine.getExecutionService().getGlobalTaskScheduler().scheduleWithRepetition(() -> {
            if (this.node.isLiteMember()) {
                return;
            }
            int licensedTsMemorySize = this.nodeExtension.getLicense().getAllowedTieredStoreSize();
            if (licensedTsMemorySize >= 99999) {
                return;
            }
            this.tsMemoryStats = this.node.hazelcastInstance.getReplicatedMap(TS_MEM_STATS_MAP);
            long tsMemoryLimitInBytes = (long)licensedTsMemorySize * 0x40000000L;
            TieredStoreServiceImpl tService = (TieredStoreServiceImpl)this.node.nodeEngine.getService("hz:ee:tieredStoreServiceImpl");
            long usedTieredStorageSize = tService.getMetrics().getPerMemberMetrics().getLastSeenHybridLogLength();
            this.tsMemoryStats.put(this.node.getThisUuid(), usedTieredStorageSize);
            if (this.node.isMaster()) {
                this.loopTSLicenseCheckRepetitions();
                this.checkMembersLiveliness(this.node);
                this.loopTSLicenseCheckRepetitions();
                long aggregatedTsMemoryConsumption = this.tsMemoryStats.values().stream().mapToLong(Long::longValue).sum();
                if (aggregatedTsMemoryConsumption > this.maxTSMemoryConsumption) {
                    this.maxTSMemoryConsumption = aggregatedTsMemoryConsumption;
                }
                long softLimit = (long)((double)tsMemoryLimitInBytes * 0.8);
                long hardLimit = (long)((double)tsMemoryLimitInBytes * 0.9);
                if (aggregatedTsMemoryConsumption >= tsMemoryLimitInBytes) {
                    this.setMemoryUsageBits(this.tsMemoryLimitFlags, 0, 1, 2);
                    this.logger.warning(TS_MEMORY_LICENSE_BREACH_MESSAGE);
                } else if (aggregatedTsMemoryConsumption >= hardLimit) {
                    this.setMemoryUsageBits(this.tsMemoryLimitFlags, 0, 1);
                    this.clearMemoryUsageBits(this.tsMemoryLimitFlags, 2);
                    this.logger.warning(String.format(MEMORY_CLOSE_TO_LIMITS_MESSAGE_TEMPLATE, CLUSTER, 90, TS));
                } else if (aggregatedTsMemoryConsumption >= softLimit) {
                    this.setMemoryUsageBits(this.tsMemoryLimitFlags, 0);
                    this.clearMemoryUsageBits(this.tsMemoryLimitFlags, 1, 2);
                    if (this.tsLicenseCheckRepetitions == 0) {
                        this.logger.info(String.format(MEMORY_CLOSE_TO_LIMITS_MESSAGE_TEMPLATE, CLUSTER, 80, TS));
                    }
                } else {
                    this.tsMemoryLimitFlags.clear();
                }
                ++this.tsLicenseCheckRepetitions;
            }
        }, licenseCheckInterval, licenseCheckInterval, TimeUnit.SECONDS);
    }

    private void checkMembersLiveliness(Node node) {
        List<UUID> aliveMembers = node.clusterService.getMembers().stream().filter(m -> !m.isLiteMember()).map(Member::getUuid).toList();
        HashSet<UUID> recordedMembers = new HashSet<UUID>(this.tsMemoryStats.keySet());
        aliveMembers.forEach(recordedMembers::remove);
        if (recordedMembers.isEmpty()) {
            return;
        }
        for (UUID leftMemberUuid : recordedMembers) {
            this.tsMemoryStats.remove(leftMemberUuid);
        }
    }

    private void loopHDLicenseCheckRepetitions() {
        if (this.hdLicenseCheckRepetitions == 5) {
            this.hdLicenseCheckRepetitions = 0;
        }
    }

    private void loopTSLicenseCheckRepetitions() {
        if (this.tsLicenseCheckRepetitions == 5) {
            this.tsLicenseCheckRepetitions = 0;
        }
    }

    private void setMemoryUsageBits(BitSet limitFlags, int ... bits) {
        for (int idx : bits) {
            limitFlags.set(idx);
        }
    }

    private void clearMemoryUsageBits(BitSet limitFlags, int ... bits) {
        for (int idx : bits) {
            limitFlags.clear(idx);
        }
    }

    public BitSet getTsMemoryLimitFlags() {
        return this.tsMemoryLimitFlags;
    }

    public BitSet getHdMemoryLimitFlags() {
        return this.hdMemoryLimitFlags;
    }

    public long getMaxTSMemoryConsumption() {
        return this.maxTSMemoryConsumption;
    }

    public static int memoryBitFlagToLimit(int bit) {
        switch (bit) {
            case 0: {
                return 80;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 100;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isUnlimitedTSLicense() {
        int licensedTsMemorySize = this.nodeExtension.getLicense().getAllowedTieredStoreSize();
        return licensedTsMemorySize >= 99999;
    }

    public void logLocalDeviceCapacityExceedsLicensedLimit(Capacity newCapacity, Capacity licensedCapacity) {
        this.logger.warning(String.format(TS_LOCAL_DEVICE_CAPACITY_EXCEED_LICENSE_LIMIT_MESSAGE, newCapacity.toPrettyString(), licensedCapacity.toPrettyString()));
    }
}

