/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.dataconnection.DataConnectionService;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.TerminatedLifecycleService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.JetService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.sql.SqlService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public final class HazelcastInstanceProxy
implements HazelcastInstance,
SerializationServiceSupport {
    protected volatile HazelcastInstanceImpl original;
    private final String name;

    protected HazelcastInstanceProxy(HazelcastInstanceImpl original) {
        this.original = original;
        this.name = original.getName();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        return this.getOriginal().getMap(name);
    }

    @Override
    @Nonnull
    public <E> IQueue<E> getQueue(@Nonnull String name) {
        return this.getOriginal().getQueue(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getTopic(@Nonnull String name) {
        return this.getOriginal().getTopic(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
        return this.getOriginal().getReliableTopic(name);
    }

    @Override
    @Nonnull
    public <E> ISet<E> getSet(@Nonnull String name) {
        return this.getOriginal().getSet(name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        return this.getOriginal().getList(name);
    }

    @Override
    @Nonnull
    public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
        return this.getOriginal().getMultiMap(name);
    }

    @Override
    @Nonnull
    public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
        return this.getOriginal().getRingbuffer(name);
    }

    @Override
    @Nonnull
    public IExecutorService getExecutorService(@Nonnull String name) {
        return this.getOriginal().getExecutorService(name);
    }

    @Override
    @Nonnull
    public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
        return this.getOriginal().getDurableExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.getOriginal().executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.getOriginal().executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.getOriginal().newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
        return this.getOriginal().newTransactionContext(options);
    }

    @Override
    @Nonnull
    public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
        return this.getOriginal().getFlakeIdGenerator(name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.getOriginal().getReplicatedMap(name);
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.getOriginal().getCacheManager();
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.getOriginal().getCluster();
    }

    @Override
    @Nonnull
    public Member getLocalEndpoint() {
        return this.getOriginal().getLocalEndpoint();
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.getOriginal().getDistributedObjects();
    }

    @Override
    @Nonnull
    public Config getConfig() {
        return this.getOriginal().getConfig();
    }

    @Override
    @Nonnull
    public PartitionService getPartitionService() {
        return this.getOriginal().getPartitionService();
    }

    @Override
    @Nonnull
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        return this.getOriginal().getSplitBrainProtectionService();
    }

    @Override
    @Nonnull
    public ClientService getClientService() {
        return this.getOriginal().getClientService();
    }

    @Override
    @Nonnull
    public LoggingService getLoggingService() {
        return this.getOriginal().getLoggingService();
    }

    @Override
    @Nonnull
    public LifecycleService getLifecycleService() {
        HazelcastInstanceImpl hz = this.original;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Override
    @Nonnull
    public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
        return this.getOriginal().getDistributedObject(serviceName, name);
    }

    @Override
    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
        return this.getOriginal().addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
        return this.getOriginal().removeDistributedObjectListener(registrationId);
    }

    @Override
    @Nonnull
    public ConcurrentMap<String, Object> getUserContext() {
        return this.getOriginal().getUserContext();
    }

    @Override
    @Nonnull
    public HazelcastXAResource getXAResource() {
        return this.getOriginal().getXAResource();
    }

    @Override
    @Nonnull
    public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
        return this.getOriginal().getCardinalityEstimator(name);
    }

    @Override
    @Nonnull
    public PNCounter getPNCounter(@Nonnull String name) {
        return this.getOriginal().getPNCounter(name);
    }

    @Override
    @Nonnull
    public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
        return this.getOriginal().getScheduledExecutorService(name);
    }

    @Override
    @Nonnull
    public CPSubsystem getCPSubsystem() {
        return this.getOriginal().getCPSubsystem();
    }

    @Override
    @Nonnull
    public SqlService getSql() {
        return this.getOriginal().getSql();
    }

    @Override
    @Nonnull
    public DataConnectionService getDataConnectionService() {
        return this.getOriginal().getDataConnectionService();
    }

    @Override
    @Nonnull
    public JetService getJet() {
        return this.getOriginal().getJet();
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.getOriginal().getSerializationService();
    }

    public HazelcastInstanceImpl getOriginal() {
        HazelcastInstanceImpl hazelcastInstance = this.original;
        if (hazelcastInstance == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        return hazelcastInstance;
    }

    public String toString() {
        HazelcastInstanceImpl hazelcastInstance = this.original;
        if (hazelcastInstance != null) {
            return hazelcastInstance.toString();
        }
        return "HazelcastInstance {NOT ACTIVE}";
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HazelcastInstance)) {
            return false;
        }
        HazelcastInstance that = (HazelcastInstance)o;
        return !(this.name == null ? that.getName() != null : !this.name.equals(that.getName()));
    }
}

