/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.sync;

import com.hazelcast.cluster.Member;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.enterprise.wan.impl.AbstractWanAntiEntropyEvent;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.sync.SyncFailedException;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventPublishOperation;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventResult;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncStateManager;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncStateStartOperation;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.monitor.WanSyncState;
import com.hazelcast.internal.monitor.impl.WanSyncStateImpl;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.impl.WanSyncStatus;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class WanSyncManager {
    private static final VarHandle SYNC_STATUS = ReflectionUtil.findVarHandle("syncStatus", WanSyncStatus.class);
    private final EnterpriseWanReplicationService wanReplicationService;
    private final ILogger logger;
    private final Node node;
    private final WanSyncStateManager wanSyncStateManager;
    private volatile WanSyncStatus syncStatus = WanSyncStatus.READY;
    private volatile String activeWanReplicationName;
    private volatile String activePublisherId;

    public WanSyncManager(EnterpriseWanReplicationService wanReplicationService, Node node) {
        this.node = node;
        this.wanReplicationService = wanReplicationService;
        this.logger = node.getLogger(this.getClass());
        this.wanSyncStateManager = new WanSyncStateManager(wanReplicationService, node);
    }

    public void initiateAntiEntropyRequest(AbstractWanAntiEntropyEvent event) {
        if (this.wanReplicationService.getPublisherOrNull(event.getWanReplicationName(), event.getWanPublisherId()) == null) {
            Object errorMsg = String.format("Sync request failed because WAN Replication Config doesn't exist with WAN configuration name %s and publisher ID %s.", event.getWanReplicationName(), event.getWanPublisherId());
            if (this.node.isLiteMember()) {
                errorMsg = (String)errorMsg + " If you have added the WAN configuration dynamically, try re-running WAN sync on non-lite members.";
            }
            throw new InvalidConfigurationException((String)errorMsg);
        }
        if (SYNC_STATUS.getAndSet(this, WanSyncStatus.IN_PROGRESS) == WanSyncStatus.IN_PROGRESS) {
            throw new SyncFailedException("Another anti-entropy request is already in progress.");
        }
        this.activeWanReplicationName = event.getWanReplicationName();
        this.activePublisherId = event.getWanPublisherId();
        Set<Member> members = this.node.getClusterService().getMembers();
        Collection dataMembers = members.stream().filter(member -> !member.isLiteMember()).collect(Collectors.toCollection(LinkedList::new));
        Collection dataMemberUUIDs = dataMembers.stream().map(Member::getUuid).collect(Collectors.toCollection(() -> new ArrayList(dataMembers.size())));
        if (this.node.getClusterService().getClusterVersion().isGreaterOrEqual(Versions.V5_3)) {
            long creationTime = System.currentTimeMillis();
            this.invokeOnMembers(() -> new WanSyncStateStartOperation(event.getUuid(), event.getWanReplicationName(), event.getWanPublisherId(), creationTime, dataMemberUUIDs), members).forEach(CompletableFuture::join);
        }
        ManagedExecutorService executor = this.node.getNodeEngine().getExecutionService().getExecutor("hz:wan:sync:pool");
        CompletableFuture.runAsync(() -> this.publishAntiEntropyEventOnMembers(event, dataMembers), executor).whenCompleteAsync((response, throwable) -> {
            if (throwable == null) {
                this.logger.info("WAN anti-entropy request " + String.valueOf(event) + " has been processed");
            } else {
                this.logger.warning("WAN anti-entropy request " + String.valueOf(event) + " processing failed", (Throwable)throwable);
            }
        }, (Executor)executor);
        this.logger.info("WAN anti-entropy request " + String.valueOf(event) + " has been sent");
    }

    public WanSyncState getWanSyncState() {
        return new WanSyncStateImpl(this.syncStatus, this.activeWanReplicationName, this.activePublisherId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishAntiEntropyEventOnMembers(AbstractWanAntiEntropyEvent event, Collection<Member> dataMembers) {
        int partitionCount = this.node.getPartitionService().getPartitionCount();
        HashSet<Integer> partitionsToSync = new HashSet<Integer>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            partitionsToSync.add(i);
        }
        try {
            List<CompletableFuture<WanAntiEntropyEventResult>> futures = this.invokeOnMembers(() -> new WanAntiEntropyEventPublishOperation(event), dataMembers);
            this.addResultOfOps(futures, partitionsToSync);
            SYNC_STATUS.set(this, (Object)(!partitionsToSync.isEmpty() ? WanSyncStatus.FAILED : WanSyncStatus.READY));
        }
        catch (Throwable throwable) {
            SYNC_STATUS.set(this, (Object)(!partitionsToSync.isEmpty() ? WanSyncStatus.FAILED : WanSyncStatus.READY));
            if (!partitionsToSync.isEmpty()) {
                this.logger.warning("WAN anti-entropy event publication failed with " + partitionsToSync.size() + " partitions not processed");
            }
            throw throwable;
        }
        if (!partitionsToSync.isEmpty()) {
            this.logger.warning("WAN anti-entropy event publication failed with " + partitionsToSync.size() + " partitions not processed");
        }
    }

    private <E> List<CompletableFuture<E>> invokeOnMembers(Supplier<Operation> supplier, Collection<Member> members) {
        return members.stream().map(member -> this.node.getNodeEngine().getOperationService().invokeOnTargetAsync("hz:core:wanReplicationService", (Operation)supplier.get(), member.getAddress())).collect(Collectors.toCollection(() -> new ArrayList(members.size())));
    }

    private void addResultOfOps(List<CompletableFuture<WanAntiEntropyEventResult>> futures, Set<Integer> partitionsToSync) {
        boolean alreadyLogged = false;
        for (Future future : futures) {
            try {
                WanAntiEntropyEventResult result = (WanAntiEntropyEventResult)future.get();
                partitionsToSync.removeAll(result.getProcessedPartitions());
            }
            catch (Exception ex) {
                if (alreadyLogged) continue;
                this.logger.warning("Exception occurred during WAN sync.", ex);
                alreadyLogged = true;
            }
        }
    }

    public void setActiveWanReplicationName(String activeWanReplicationName) {
        this.activeWanReplicationName = activeWanReplicationName;
    }

    public void setActivePublisherId(String activePublisherId) {
        this.activePublisherId = activePublisherId;
    }

    public WanSyncStateManager getWanSyncStateManager() {
        return this.wanSyncStateManager;
    }
}

