/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.sync;

import com.hazelcast.enterprise.wan.impl.AbstractWanAntiEntropyEvent;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.enterprise.wan.impl.sync.WanSyncStateManager;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.SelfResponseOperation;
import java.io.IOException;

public class WanAntiEntropyEventPublishOperation
extends Operation
implements IdentifiedDataSerializable,
AllowedDuringPassiveState,
SelfResponseOperation,
Versioned {
    private AbstractWanAntiEntropyEvent event;

    public WanAntiEntropyEventPublishOperation() {
    }

    public WanAntiEntropyEventPublishOperation(AbstractWanAntiEntropyEvent event) {
        this.event = event;
    }

    @Override
    public void run() throws Exception {
        EnterpriseWanReplicationService wanReplicationService = (EnterpriseWanReplicationService)this.getService();
        this.event.setOp(this);
        try {
            wanReplicationService.publishAntiEntropyEvent(this.event);
        }
        catch (Exception e) {
            wanReplicationService.getSyncManager().getWanSyncStateManager().finishLocal(this.event.getUuid(), WanSyncStateManager.WanSyncStateStage.FAILED);
            throw e;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (!out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            out.writeString(this.event.getWanReplicationName());
            out.writeString(this.event.getWanPublisherId());
        }
        out.writeObject(this.event);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        if (in.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            this.event = (AbstractWanAntiEntropyEvent)in.readObject();
        } else {
            String wanReplicationName = in.readString();
            String wanPublisherId = in.readString();
            this.event = (AbstractWanAntiEntropyEvent)in.readObject();
            if (this.event != null) {
                this.event.setWanReplicationName(wanReplicationName);
                this.event.setWanPublisherId(wanPublisherId);
            }
        }
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }
}

