/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.enterprise.wan.impl.replication.ComparisonState;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import java.util.Map;

class MerkleTreeComparisonProcessor {
    private final ILogger logger = Logger.getLogger(MerkleTreeComparisonProcessor.class);
    private ComparisonState comparisonState = ComparisonState.IN_PROGRESS;
    private Map<Integer, int[]> lastLocalNodeValues;
    private Map<Integer, int[]> lastRemoteNodeValues;
    private Map<Integer, int[]> difference;
    private int localTreeLevel = -1;
    private int remoteTreeLevel = -1;

    MerkleTreeComparisonProcessor() {
    }

    void processLocalNodeValues(Map<Integer, int[]> localNodeValues) {
        assert (this.comparisonState == ComparisonState.IN_PROGRESS);
        this.lastLocalNodeValues = localNodeValues;
        this.localTreeLevel = MerkleTreeComparisonProcessor.extractTreeLevel(localNodeValues, this.localTreeLevel);
        if (localNodeValues.containsValue(null)) {
            this.difference = this.localize(this.lastRemoteNodeValues, this.localTreeLevel);
            this.comparisonState = ComparisonState.FINISHED;
        } else if (this.localTreeLevel == this.remoteTreeLevel) {
            this.difference = localNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        } else if (localNodeValues.isEmpty()) {
            this.difference = localNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        }
    }

    void processRemoteNodeValues(Map<Integer, int[]> remoteNodeValues) {
        assert (this.comparisonState == ComparisonState.IN_PROGRESS);
        this.lastRemoteNodeValues = remoteNodeValues;
        if (remoteNodeValues == null) {
            this.comparisonState = ComparisonState.ABORTED;
            this.logger.fine("Connection manager is shutting down, aborting merkle tree sync");
            return;
        }
        this.remoteTreeLevel = MerkleTreeComparisonProcessor.extractTreeLevel(remoteNodeValues, this.remoteTreeLevel);
        if (remoteNodeValues.containsValue(null)) {
            this.difference = this.lastLocalNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        } else if (this.localTreeLevel == this.remoteTreeLevel) {
            this.difference = remoteNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        } else if (remoteNodeValues.isEmpty()) {
            this.difference = remoteNodeValues;
            this.comparisonState = ComparisonState.FINISHED;
        }
    }

    boolean isComparisonFinished() {
        return this.comparisonState == ComparisonState.FINISHED || this.comparisonState == ComparisonState.ABORTED;
    }

    Map<Integer, int[]> getDifference() {
        return this.difference;
    }

    ComparisonState getComparisonState() {
        return this.comparisonState;
    }

    private static int extractTreeLevel(Map<Integer, int[]> nodeValues, int currentLevel) {
        for (int[] diffs : nodeValues.values()) {
            if (diffs == null || diffs.length <= 0) continue;
            return MerkleTreeUtil.getLevelOfNode(diffs[0]);
        }
        return currentLevel;
    }

    private Map<Integer, int[]> localize(Map<Integer, int[]> diff, int leafLevel) {
        Map<Integer, int[]> localizedDiff = MapUtil.createHashMap(diff.size());
        for (Map.Entry<Integer, int[]> entry : diff.entrySet()) {
            int[] nodeValues = entry.getValue();
            if (nodeValues != null && nodeValues.length > 0 && MerkleTreeUtil.getLevelOfNode(nodeValues[0]) > leafLevel) {
                int[] localizedNodeValues = new int[nodeValues.length / 2];
                int localizedIdx = 0;
                for (int i = 0; i < nodeValues.length; i += 4) {
                    int leftChildOrder = nodeValues[i];
                    int leftChildHash = nodeValues[i + 1];
                    int rightChildHash = nodeValues[i + 3];
                    int parentChildOrder = MerkleTreeUtil.getParentOrder(leftChildOrder);
                    localizedNodeValues[localizedIdx++] = parentChildOrder;
                    localizedNodeValues[localizedIdx++] = MerkleTreeUtil.sumHash(leftChildHash, rightChildHash);
                }
                localizedDiff.put(entry.getKey(), localizedNodeValues);
                continue;
            }
            localizedDiff.put(entry.getKey(), entry.getValue());
        }
        return localizedDiff;
    }
}

