/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.wan.impl.WanSyncStats;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FullWanSyncStats
implements WanSyncStats {
    private final UUID uuid;
    @Probe(name="syncStartNanos", unit=ProbeUnit.NS)
    private final long syncStartNanos = System.nanoTime();
    @Probe(name="partitionsToSync")
    private final int partitionsToSync;
    @Probe(name="partitionsSynced")
    private AtomicInteger partitionsSynced = new AtomicInteger();
    @Probe(name="recordsSynced")
    private AtomicInteger recordsSynced = new AtomicInteger();
    @Probe(name="syncDurationNanos", unit=ProbeUnit.NS)
    private volatile long syncDurationNanos;

    FullWanSyncStats(UUID uuid, int partitionsToSync) {
        this.uuid = uuid;
        this.partitionsToSync = partitionsToSync;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getPartitionsToSync() {
        return this.partitionsToSync;
    }

    int onSyncPartition() {
        return this.partitionsSynced.incrementAndGet();
    }

    void onSyncRecord() {
        this.recordsSynced.incrementAndGet();
    }

    void onSyncComplete() {
        this.syncDurationNanos = System.nanoTime() - this.syncStartNanos;
    }

    @Override
    public long getDurationSecs() {
        return TimeUnit.NANOSECONDS.toSeconds(this.syncDurationNanos);
    }

    @Override
    public int getPartitionsSynced() {
        return this.partitionsSynced.get();
    }

    @Override
    public int getRecordsSynced() {
        return this.recordsSynced.get();
    }

    public String toString() {
        return "FullWanSyncStats{uuid=" + String.valueOf(this.uuid) + ", syncStartNanos=" + this.syncStartNanos + ", partitionsToSync=" + this.partitionsToSync + ", partitionsSynced=" + String.valueOf(this.partitionsSynced) + ", recordsSynced=" + String.valueOf(this.recordsSynced) + ", syncDurationNanos=" + this.syncDurationNanos + "}";
    }
}

