/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.connection;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.enterprise.wan.impl.connection.WanConnectionException;
import com.hazelcast.enterprise.wan.impl.connection.WanConnectionWrapper;
import com.hazelcast.enterprise.wan.impl.discovery.UnresolvableStaticDiscoveryNode;
import com.hazelcast.enterprise.wan.impl.operation.WanProtocolNegotiationOperation;
import com.hazelcast.enterprise.wan.impl.operation.WanProtocolNegotiationResponse;
import com.hazelcast.enterprise.wan.impl.operation.WanProtocolNegotiationStatus;
import com.hazelcast.enterprise.wan.impl.replication.WanConfigurationContext;
import com.hazelcast.enterprise.wan.impl.replication.compact.WanCompactSchemaReplicationManager;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.serialization.impl.compact.schema.EnterpriseMemberSchemaService;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerConnectionManager;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.impl.PredefinedDiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class WanConnectionManager
implements ConnectionListener<ServerConnection> {
    private static final int DEFAULT_RETRY_CONNECTION_MAX = 10;
    static int retryConnectionMax = 10;
    private static final int DISCOVERY_TASK_START_DELAY = 10;
    private static final int RETRY_CONNECTION_SLEEP_MILLIS = 1000;
    final DiscoveryService discoveryService;
    private final Node node;
    private final ILogger logger;
    private final ConcurrentMap<Address, WanConnectionWrapper> connectionPool = new ConcurrentHashMap<Address, WanConnectionWrapper>();
    private final List<Address> targetEndpoints = new CopyOnWriteArrayList<Address>();
    private final Set<Address> connectionsInProgress = ConcurrentHashMap.newKeySet();
    private final WanCompactSchemaReplicationManager wanCompactSchemaReplicationManager;
    private WanConfigurationContext configurationContext;
    private EndpointQualifier endpointQualifier;
    private volatile boolean running = true;

    public WanConnectionManager(Node node, DiscoveryService discoveryService) {
        this.node = node;
        this.logger = node.getLogger(WanConnectionManager.class.getName());
        this.discoveryService = discoveryService;
        this.wanCompactSchemaReplicationManager = ((EnterpriseMemberSchemaService)node.getSchemaService()).getWanCompactSchemaReplicationManager();
    }

    public void init(WanConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        String endpointIdentifier = configurationContext.getPublisherConfig().getEndpoint();
        this.endpointQualifier = endpointIdentifier == null ? EndpointQualifier.MEMBER : EndpointQualifier.resolve(ProtocolType.WAN, endpointIdentifier);
        this.node.server.getConnectionManager(this.endpointQualifier).addConnectionListener(this);
        int nodesConfigured = 0;
        try {
            DiscoveryResult discoveryResult = this.discoverEndpointAddresses();
            nodesConfigured = discoveryResult.nodesConfigured;
            this.addToTargetEndpoints(discoveryResult.discoveredAddresses);
        }
        catch (Exception e) {
            String msg = "Failed to initialize WAN endpoint list";
            if (this.discoveryService instanceof PredefinedDiscoveryService) {
                throw new InvalidConfigurationException("Failed to initialize WAN endpoint list", e);
            }
            this.logger.warning("Failed to initialize WAN endpoint list", e);
        }
        if (nodesConfigured == 0) {
            String msg = "There were no discovered nodes for WanBatchReplicationPublisherConfig,please define endpoints statically or check the discovery config";
            if (this.discoveryService instanceof PredefinedDiscoveryService) {
                throw new InvalidConfigurationException("There were no discovered nodes for WanBatchReplicationPublisherConfig,please define endpoints statically or check the discovery config");
            }
            this.logger.warning("There were no discovered nodes for WanBatchReplicationPublisherConfig,please define endpoints statically or check the discovery config");
        } else if (this.targetEndpoints.isEmpty()) {
            this.logger.warning("WAN replication initialized without the configured target endpoints because none of them were found to be healthy (this could be due to eager connection health checks being enabled with the static discovery strategy). WAN events are not getting replicated until at least one endpoint can be resolved by the periodic WAN target endpoint discovery task. Please note this state of WAN may lead to filling up the WAN replication event queue.");
        }
        this.node.getNodeEngine().getExecutionService().scheduleWithRepetition(new TargetEndpointDiscoveryTask(), 10L, configurationContext.getDiscoveryPeriodSeconds(), TimeUnit.SECONDS);
    }

    public List<Address> awaitAndGetTargetEndpoints() {
        while (this.running) {
            List<Address> endpoints = this.getTargetEndpoints();
            if (!endpoints.isEmpty()) {
                return endpoints;
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
            }
        }
        return Collections.emptyList();
    }

    public void shutdown() {
        this.running = false;
    }

    private void addToTargetEndpoints(List<Address> addresses) {
        int endpointCount = Math.min(this.configurationContext.getMaxEndpoints() - this.targetEndpoints.size(), addresses.size());
        this.targetEndpoints.addAll(addresses.subList(0, endpointCount));
    }

    private DiscoveryResult discoverEndpointAddresses() {
        int nodesConfigured = 0;
        Iterable<DiscoveryNode> nodes = this.discoveryService.discoverNodes();
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (DiscoveryNode node : nodes) {
            Address address;
            ++nodesConfigured;
            if (node instanceof UnresolvableStaticDiscoveryNode) {
                this.logger.warning(String.format("Target endpoint '%s' could not be resolved. The endpoint will be added to the target endpoint list if it becomes resolvable.", ((UnresolvableStaticDiscoveryNode)node).getEndpoint()));
                continue;
            }
            Address address2 = address = this.configurationContext.isUseEndpointPrivateAddress() ? node.getPrivateAddress() : node.getPublicAddress();
            if (address != null) {
                if (node.getProperties().getOrDefault("healthy", "True").equals("True")) {
                    addresses.add(address);
                    continue;
                }
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest("Skipping endpoint %s as it is marked unhealthy...", address);
                continue;
            }
            if (!this.logger.isFinestEnabled()) continue;
            this.logger.finest("Discovery strategy returned a null address, ignoring...");
        }
        return new DiscoveryResult(addresses, nodesConfigured);
    }

    public WanConnectionWrapper getConnection(Address target) {
        Address targetAddress = this.selectTarget(target);
        return this.getConnectionByTargetAddress(targetAddress);
    }

    public boolean isConnected() {
        for (Address target : this.targetEndpoints) {
            WanConnectionWrapper wrapper = (WanConnectionWrapper)this.connectionPool.get(target);
            if (wrapper == null || !wrapper.getConnection().isAlive()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTargetEndpoint(Address targetAddress, String reason, Throwable cause, boolean markUnhealthy) {
        boolean removed;
        List<Address> list = this.targetEndpoints;
        synchronized (list) {
            removed = this.targetEndpoints.remove(targetAddress);
        }
        WanConnectionWrapper wrapper = (WanConnectionWrapper)this.connectionPool.remove(targetAddress);
        if (wrapper != null) {
            try {
                wrapper.getConnection().close(reason, cause);
            }
            catch (Exception e) {
                this.logger.warning("Error closing connection", e);
            }
        }
        if (markUnhealthy && removed) {
            this.discoveryService.markEndpointAsUnhealthy(targetAddress);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address selectFirstTarget() {
        List<Address> list = this.targetEndpoints;
        synchronized (list) {
            if (!this.targetEndpoints.isEmpty()) {
                return this.targetEndpoints.get(0);
            }
        }
        try {
            this.targetEndpoints.wait(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.finest("WanConnectionManager wait interrupted.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address selectTarget(Address target) {
        List<Address> list = this.targetEndpoints;
        synchronized (list) {
            return this.targetEndpoints.contains(target) ? target : this.selectFirstTarget();
        }
    }

    private WanConnectionWrapper getConnectionByTargetAddress(Address targetAddress) {
        block6: {
            if (targetAddress == null) {
                return null;
            }
            try {
                WanConnectionWrapper wrapper = ConcurrencyUtil.getOrPutSynchronized(this.connectionPool, targetAddress, this.connectionPool, this::connectAndNegotiate);
                if (wrapper.getConnection().isAlive()) {
                    return wrapper;
                }
                this.removeTargetEndpoint(targetAddress, "Connection to WAN endpoint " + String.valueOf(targetAddress) + " is dead", null, true);
            }
            catch (WanConnectionException e) {
                if (this.removeTargetEndpoint(targetAddress, e.getMessage(), e, true)) {
                    this.logger.warning("Failed to establish a connection to a WAN endpoint: " + e.getMessage());
                }
            }
            catch (Throwable e) {
                String msg = "Failed to connect to WAN endpoint: " + String.valueOf(targetAddress);
                if (!this.removeTargetEndpoint(targetAddress, msg, e, true)) break block6;
                this.logger.warning(msg, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WanConnectionWrapper connectAndNegotiate(Address targetAddress) {
        try {
            this.connectionsInProgress.add(targetAddress);
            ServerConnectionManager connectionManager = this.node.getServer().getConnectionManager(this.endpointQualifier);
            if (connectionManager == null) {
                connectionManager = this.node.getServer().getConnectionManager(EndpointQualifier.MEMBER);
            }
            ServerConnection conn = connectionManager.getOrConnect(targetAddress);
            for (int i = 0; i < retryConnectionMax; ++i) {
                if (conn == null) {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                    conn = connectionManager.getOrConnect(targetAddress);
                }
                if (conn == null) continue;
                WanConnectionWrapper wanConnectionWrapper = new WanConnectionWrapper(targetAddress, conn, this.negotiateWanProtocol(conn, targetAddress));
                return wanConnectionWrapper;
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.logger.finest("Sleep interrupted", ie);
        }
        finally {
            this.connectionsInProgress.remove(targetAddress);
        }
        throw new WanConnectionException("WAN connection to " + String.valueOf(targetAddress) + " was not established in " + TimeUnit.MILLISECONDS.toSeconds(retryConnectionMax * 1000) + " seconds.");
    }

    public ConcurrentMap<Address, WanConnectionWrapper> getConnectionPool() {
        return this.connectionPool;
    }

    private WanProtocolNegotiationResponse negotiateWanProtocol(Connection conn, Address targetAddress) {
        String errorMsg;
        String targetClusterName = this.configurationContext.getClusterName();
        List<Version> supportedWanProtocolVersions = this.node.getNodeEngine().getWanReplicationService().getSupportedWanProtocolVersions();
        String sourceClusterName = this.node.getConfig().getClusterName();
        WanProtocolNegotiationOperation negotiationOp = new WanProtocolNegotiationOperation(sourceClusterName, targetClusterName, supportedWanProtocolVersions);
        InvocationFuture future = this.node.getNodeEngine().getOperationService().createInvocationBuilder("hz:core:wanReplicationService", (Operation)negotiationOp, targetAddress).setTryCount(1).setConnectionManager(this.node.getServer().getConnectionManager(this.endpointQualifier)).invoke();
        Exception negotiationException = null;
        try {
            WanProtocolNegotiationResponse response = (WanProtocolNegotiationResponse)future.get();
            WanProtocolNegotiationStatus status = response.getStatus();
            if (status == WanProtocolNegotiationStatus.OK) {
                return response;
            }
            errorMsg = "WAN protocol negotiation failed for cluster name " + targetClusterName + " and target " + String.valueOf(targetAddress) + " with status " + String.valueOf((Object)status);
        }
        catch (Exception exception) {
            negotiationException = exception;
            errorMsg = "WAN protocol negotiation failed for cluster name " + targetClusterName + " and target " + String.valueOf(targetAddress);
        }
        conn.close(errorMsg, null);
        throw new WanConnectionException(errorMsg, negotiationException);
    }

    public List<Address> getTargetEndpoints() {
        return new ArrayList<Address>(this.targetEndpoints);
    }

    @Override
    public void connectionAdded(ServerConnection connection) {
    }

    @Override
    public void connectionRemoved(ServerConnection connection) {
        Address remoteAddress = connection.getRemoteAddress();
        WanConnectionWrapper wrapper = (WanConnectionWrapper)this.connectionPool.remove(remoteAddress);
        this.wanCompactSchemaReplicationManager.onConnectionClose(wrapper);
        OperationServiceImpl operationService = this.node.nodeEngine.getOperationService();
        if (wrapper != null || this.connectionsInProgress.contains(remoteAddress)) {
            operationService.onEndpointLeft(remoteAddress);
        }
    }

    private static final class DiscoveryResult {
        private final List<Address> discoveredAddresses;
        private final int nodesConfigured;

        private DiscoveryResult(List<Address> discoveredNodes, int nodesConfigured) {
            this.discoveredAddresses = discoveredNodes;
            this.nodesConfigured = nodesConfigured;
        }
    }

    private class TargetEndpointDiscoveryTask
    implements Runnable {
        private TargetEndpointDiscoveryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List<Address> discoveredNodes = WanConnectionManager.this.discoverEndpointAddresses().discoveredAddresses;
                List<Address> list = WanConnectionManager.this.targetEndpoints;
                synchronized (list) {
                    WanConnectionManager.this.targetEndpoints.retainAll(discoveredNodes);
                    discoveredNodes.removeAll(WanConnectionManager.this.targetEndpoints);
                    if (discoveredNodes.size() > 0) {
                        WanConnectionManager.this.addToTargetEndpoints(discoveredNodes);
                        WanConnectionManager.this.targetEndpoints.notify();
                    }
                }
            }
            catch (Exception e) {
                WanConnectionManager.this.logger.fine("Failed to discover new nodes for WAN replication", e);
            }
        }
    }
}

