/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventPublishOperation;
import com.hazelcast.enterprise.wan.impl.sync.WanAntiEntropyEventResult;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.wan.impl.WanAntiEntropyEvent;
import java.io.IOException;
import java.util.UUID;

public abstract class AbstractWanAntiEntropyEvent
implements IdentifiedDataSerializable,
WanAntiEntropyEvent,
Versioned {
    protected String wanReplicationName;
    protected String wanPublisherId;
    protected UUID uuid;
    protected String mapName;
    private transient WanAntiEntropyEventPublishOperation op;
    private transient WanAntiEntropyEventResult processingResult;

    public AbstractWanAntiEntropyEvent() {
    }

    public AbstractWanAntiEntropyEvent(String wanReplicationName, String wanPublisherId, String mapName) {
        this.wanReplicationName = wanReplicationName;
        this.wanPublisherId = wanPublisherId;
        this.uuid = UuidUtil.newUnsecureUUID();
        this.mapName = mapName;
    }

    @Override
    public String getWanReplicationName() {
        return this.wanReplicationName;
    }

    @Override
    public String getWanPublisherId() {
        return this.wanPublisherId;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getObjectName() {
        return this.mapName;
    }

    public WanAntiEntropyEventPublishOperation getOp() {
        return this.op;
    }

    public void setOp(WanAntiEntropyEventPublishOperation op) {
        this.op = op;
    }

    public WanAntiEntropyEventResult getProcessingResult() {
        return this.processingResult;
    }

    public void setProcessingResult(WanAntiEntropyEventResult processingResult) {
        this.processingResult = processingResult;
    }

    public void sendResponse() {
        try {
            this.op.sendResponse(this.processingResult);
        }
        catch (Exception ex) {
            this.op.getNodeEngine().getLogger(AbstractWanAntiEntropyEvent.class).warning(ex);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        if (out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            out.writeString(this.wanReplicationName);
            out.writeString(this.wanPublisherId);
        }
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeString(this.mapName);
        if (!out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            out.writeInt(0);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        if (in.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            this.wanReplicationName = in.readString();
            this.wanPublisherId = in.readString();
        }
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.mapName = in.readString();
        if (!in.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                in.readInt();
            }
        }
    }

    public void setWanReplicationName(String wanReplicationName) {
        this.wanReplicationName = wanReplicationName;
    }

    public void setWanPublisherId(String wanPublisherId) {
        this.wanPublisherId = wanPublisherId;
    }
}

