/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raftop.snapshot;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.snapshot.ChunkUtil;
import com.hazelcast.cp.internal.datastructures.snapshot.DataChunkGroup;
import com.hazelcast.cp.internal.raft.ChunkedSnapshotAwareService;
import com.hazelcast.cp.internal.raft.SnapshotAwareService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class RestoreSnapshotOp
extends RaftOp
implements IdentifiedDataSerializable {
    private String serviceName;
    private Object snapshot;

    public RestoreSnapshotOp() {
    }

    public RestoreSnapshotOp(String serviceName, Object snapshot) {
        this.serviceName = serviceName;
        this.snapshot = snapshot;
    }

    public Object getSnapshot() {
        return this.snapshot;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object run(CPGroupId groupId, long commitIndex) {
        SnapshotAwareService service = (SnapshotAwareService)this.getService();
        if (service instanceof ChunkedSnapshotAwareService) {
            ChunkedSnapshotAwareService chunkedService = (ChunkedSnapshotAwareService)service;
            if (this.isChunkingSupportedVersion()) {
                chunkedService.restoreChunkedSnapshot(groupId, commitIndex, (DataChunkGroup)this.snapshot);
                return null;
            }
        }
        service.restoreSnapshot(groupId, commitIndex, this.snapshot);
        return null;
    }

    public boolean isChunkingSupportedVersion() {
        return this.getNodeEngine().getClusterService().getClusterVersion().isGreaterOrEqual(ChunkUtil.MIN_CHUNKING_SUPPORTED_VERSION);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.serviceName);
        out.writeObject(this.snapshot);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.serviceName = in.readString();
        this.snapshot = in.readObject();
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 29;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshotOp that = (RestoreSnapshotOp)o;
        return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.snapshot, that.snapshot);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.serviceName);
        result = 31 * result + Objects.hashCode(this.snapshot);
        return result;
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(", snapshot=").append(this.snapshot);
    }
}

