/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raftop.metadata;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.RaftSystemOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PublishCPGroupInfoOp
extends Operation
implements IdentifiedDataSerializable,
RaftSystemOperation {
    private CPMember cpLeader;
    private Map<CPGroupId, Set<CPMember>> followerInfo;
    private Map<CPGroupId, Integer> groupToTerm;

    public PublishCPGroupInfoOp() {
    }

    public PublishCPGroupInfoOp(CPMember leader, Map<CPGroupId, Set<CPMember>> followerInfo, Map<CPGroupId, Integer> groupToTerm) {
        this.cpLeader = leader;
        this.followerInfo = followerInfo;
        this.groupToTerm = groupToTerm;
        assert (groupToTerm.keySet().containsAll(followerInfo.keySet()));
    }

    @Override
    public void run() {
        RaftService service = (RaftService)this.getService();
        this.getLogger().finest("Received PublishCPGroupInfoOp from %s[%s]: leader: %s, followers: %s, terms: %s", this.getCallerUuid(), this.getCallerAddress(), this.cpLeader, this.followerInfo, this.groupToTerm);
        service.getGroupViewTracker().receiveUpdateForLedGroups(this.cpLeader, this.followerInfo, this.groupToTerm);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 54;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.cpLeader);
        out.writeInt(this.followerInfo.size());
        for (Map.Entry<CPGroupId, Set<CPMember>> entry : this.followerInfo.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeInt(this.groupToTerm.get(entry.getKey()));
            out.writeInt(entry.getValue().size());
            for (CPMember cpMember : entry.getValue()) {
                out.writeObject(cpMember);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.cpLeader = (CPMember)in.readObject();
        int groupsLen = in.readInt();
        this.followerInfo = new HashMap<CPGroupId, Set<CPMember>>(groupsLen);
        this.groupToTerm = new HashMap<CPGroupId, Integer>(groupsLen);
        for (int i = 0; i < groupsLen; ++i) {
            CPGroupId groupId = (CPGroupId)in.readObject();
            int term = in.readInt();
            int followersLen = in.readInt();
            HashSet<CPMember> followers = new HashSet<CPMember>(followersLen);
            for (int k = 0; k < followersLen; ++k) {
                followers.add((CPMember)in.readObject());
            }
            this.followerInfo.put(groupId, followers);
            this.groupToTerm.put(groupId, term);
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(", cpLeader=").append(this.cpLeader).append(", followerInfo=").append(this.followerInfo).append(", groupToTerm=").append(this.groupToTerm);
    }
}

