/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.handler;

import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.dto.TriggerLeaderElection;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;
import com.hazelcast.cp.internal.raft.impl.task.LeaderElectionTask;
import com.hazelcast.cp.internal.raft.impl.task.RaftNodeStatusAwareTask;

public class TriggerLeaderElectionHandlerTask
extends RaftNodeStatusAwareTask
implements Runnable {
    private final TriggerLeaderElection req;

    public TriggerLeaderElectionHandlerTask(RaftNodeImpl raftNode, TriggerLeaderElection req) {
        super(raftNode);
        this.req = req;
    }

    @Override
    protected void innerRun() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received %s", this.req);
        }
        RaftState state = this.raftNode.state();
        if (this.req.term() != state.term() || !this.req.leader().equals(state.leader())) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Ignoring " + String.valueOf(this.req) + " since term: " + state.term() + " and leader: " + String.valueOf(state.leader()));
            }
            return;
        }
        LogEntry entry = state.log().lastLogOrSnapshotEntry();
        if (entry.index() != this.req.lastLogIndex() || entry.term() != this.req.lastLogTerm()) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Could not accept leadership transfer because local Raft log is not same with the current leader. Last log entry: " + String.valueOf(entry) + ", request: " + String.valueOf(this.req));
            }
            return;
        }
        this.logger.info("Starting a new leader election since the current leader: " + String.valueOf(this.req.leader()) + " in term: " + this.req.term() + " asked for a leadership transfer!");
        state.leader(null);
        new LeaderElectionTask(this.raftNode, true).run();
    }
}

