/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.handler;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.RaftRole;
import com.hazelcast.cp.internal.raft.impl.dto.InstallSnapshotResponse;
import com.hazelcast.cp.internal.raft.impl.handler.AbstractResponseHandlerTask;
import com.hazelcast.cp.internal.raft.impl.state.FollowerState;
import com.hazelcast.cp.internal.raft.impl.state.LeaderState;
import com.hazelcast.cp.internal.raft.impl.state.QueryState;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;

public class InstallSnapshotResponseHandlerTask
extends AbstractResponseHandlerTask
implements Runnable {
    private final InstallSnapshotResponse response;

    public InstallSnapshotResponseHandlerTask(RaftNodeImpl raftNode, InstallSnapshotResponse response) {
        super(raftNode);
        this.response = response;
    }

    @Override
    protected void handleResponse() {
        RaftState state = this.raftNode.state();
        if (state.role() != RaftRole.LEADER) {
            this.logger.warning("Ignored " + String.valueOf(this.response) + ". We are not LEADER anymore.");
            return;
        }
        assert (this.response.term() <= state.term()) : "Invalid " + String.valueOf(this.response) + " for current term: " + state.term();
        this.logger.fine("Received %s", this.response);
        RaftEndpoint follower = this.response.follower();
        LeaderState leaderState = state.leaderState();
        QueryState queryState = leaderState.queryState();
        if (queryState.tryAck(this.response.queryRound(), follower)) {
            this.logger.fine("Ack from %s for query round: %d", follower, this.response.queryRound());
        }
        this.raftNode.tryRunQueries();
        FollowerState followerState = leaderState.getFollowerState(this.sender());
        followerState.appendRequestAckReceived(this.response.flowControlSequenceNumber());
        this.raftNode.sendNextSnapshotChunk(this.sender(), this.response.snapshotIndex(), this.response.requestedChunkNumber());
    }

    @Override
    protected RaftEndpoint sender() {
        return this.response.follower();
    }
}

