/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.handler;

import com.hazelcast.cp.internal.raft.impl.RaftNodeImpl;
import com.hazelcast.cp.internal.raft.impl.RaftRole;
import com.hazelcast.cp.internal.raft.impl.dto.AppendFailureResponse;
import com.hazelcast.cp.internal.raft.impl.dto.InstallSnapshotRequest;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotChunk;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;
import com.hazelcast.cp.internal.raft.impl.task.RaftNodeStatusAwareTask;

public class InstallSnapshotRequestHandlerTask
extends RaftNodeStatusAwareTask
implements Runnable {
    private final InstallSnapshotRequest req;

    public InstallSnapshotRequestHandlerTask(RaftNodeImpl raftNode, InstallSnapshotRequest req) {
        super(raftNode);
        this.req = req;
    }

    @Override
    protected void innerRun() {
        this.logger.fine("Received %s", this.req);
        RaftState state = this.raftNode.state();
        SnapshotChunk newChunk = this.req.snapshotChunk();
        if (this.req.term() < state.term()) {
            this.logger.fine("Stale snapshot: %s received in current term: %d, snapshotIndex: %d", this.req, state.term(), newChunk.index());
            this.raftNode.send(new AppendFailureResponse(this.localMember(), state.term(), newChunk.index() + 1L, this.req.flowControlSequenceNumber(), -1L), this.req.leader());
            return;
        }
        if (this.req.term() > state.term() || state.role() != RaftRole.FOLLOWER) {
            this.logger.info("Demoting to FOLLOWER from current role: " + String.valueOf((Object)state.role()) + ", term: " + state.term() + " to new term: " + this.req.term() + " and leader: " + String.valueOf(this.req.leader()));
            this.raftNode.toFollower(this.req.term());
        }
        this.logger.info(String.format("Received snapshot chunk from leaderUuid=%s, %s", this.req.leader().getUuid(), newChunk));
        if (!this.req.leader().equals(state.leader())) {
            this.logger.info("Setting leader: " + String.valueOf(this.req.leader()));
            this.raftNode.leader(this.req.leader());
        }
        this.raftNode.updateLastAppendEntriesTimestamp();
        this.raftNode.getChunkedSnapshotInstaller().processChunk(this.req);
    }
}

