/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.snapshot;

import com.hazelcast.cp.internal.datastructures.snapshot.AbstractDataChunk;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.Objects;

public class ValueDataChunk
extends AbstractDataChunk {
    private Data value;

    public ValueDataChunk() {
    }

    public ValueDataChunk(String name, Data value) {
        this(name, value, false);
    }

    public ValueDataChunk(String name, boolean destroyed) {
        this(name, null, destroyed);
    }

    private ValueDataChunk(String name, Data value, boolean destroyed) {
        super(name, destroyed);
        this.value = destroyed ? null : value;
        this.addToChunkSize(value == null ? 0L : (long)value.dataSize());
    }

    public Data getValue() {
        return this.value;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    void writeDataInternal(ObjectDataOutput out) throws IOException {
        IOUtil.writeData(out, this.value);
    }

    @Override
    void readDataInternal(ObjectDataInput in) throws IOException {
        this.value = IOUtil.readData(in);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueDataChunk that = (ValueDataChunk)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    @Override
    public String toString() {
        return "ValueDataChunk{value=" + String.valueOf(this.value) + "} " + super.toString();
    }
}

