/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.snapshot;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerConstants;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DataChunkGroup<T>
implements IdentifiedDataSerializable {
    private List<T> data = new ArrayList<T>();

    public DataChunkGroup<T> add(T item) {
        Objects.requireNonNull(item, "Item cannot be null");
        this.data.add(item);
        return this;
    }

    public List<T> getServiceData() {
        return this.data;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerConstants.F_ID;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.data.size());
        for (T item : this.data) {
            out.writeObject(item);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        ArrayList<T> newData = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            Object item = in.readObject();
            newData.add(item);
        }
        this.data = newData;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataChunkGroup that = (DataChunkGroup)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }

    public String toString() {
        return "Chunk{data=" + String.valueOf(this.data) + "}";
    }
}

