/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.snapshot;

import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRefSnapshot;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapRegistrySnapshot;
import com.hazelcast.cp.internal.datastructures.snapshot.AbstractDataChunk;
import com.hazelcast.cp.internal.datastructures.snapshot.DataChunkGroup;
import com.hazelcast.cp.internal.datastructures.snapshot.KeyValueDataChunk;
import com.hazelcast.cp.internal.datastructures.snapshot.ValueDataChunk;
import com.hazelcast.cp.internal.raft.ChunkedSnapshotAwareService;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftIntegration;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotChunk;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.cp.internal.raftop.snapshot.RestoreSnapshotOp;
import com.hazelcast.cp.internal.util.ListTypeUtils;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ChunkUtil {
    public static final Version MIN_CHUNKING_SUPPORTED_VERSION = Versions.V5_6;
    public static final long DEFAULT_CHUNK_SIZE_IN_MB = 250L;
    public static final String PROP_MAX_CHUNK_SIZE_IN_MB = "hazelcast.cp.snapshot.chunk.max.size.mb";
    public static final HazelcastProperty MAX_CHUNK_SIZE_IN_MB = new HazelcastProperty("hazelcast.cp.snapshot.chunk.max.size.mb", 250L);

    private ChunkUtil() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    @Nonnull
    public static List<SnapshotChunk> createChunksFromSnapshot(RaftIntegration raftIntegration, int snapshotTerm, long commitIndex, Collection<RaftEndpoint> members, long membersIndex, Object snapshot, ILogger logger) {
        if (snapshot instanceof List && ListTypeUtils.firstElementIsInstanceOf((List)snapshot, SnapshotChunk.class)) {
            return (List)snapshot;
        }
        assert (snapshot instanceof Map) : "Snapshot must be a Map";
        Map snapshotPerServiceInfo = (Map)snapshot;
        ArrayList<SnapshotChunk> chunkedServiceSnapshots = new ArrayList<SnapshotChunk>();
        ArrayList<Object> nonChunkedServiceOps = new ArrayList<Object>();
        ChunkUtil.processSnapshotServices(raftIntegration, snapshotPerServiceInfo, commitIndex, chunkedServiceSnapshots, nonChunkedServiceOps, logger);
        ChunkUtil.optimizeChunks(chunkedServiceSnapshots, nonChunkedServiceOps);
        return ChunkUtil.finalizeChunks(chunkedServiceSnapshots, snapshotTerm, commitIndex, members, membersIndex);
    }

    private static void processSnapshotServices(RaftIntegration raftIntegration, Map<?, ?> snapshotPerServiceInfo, long commitIndex, List<SnapshotChunk> chunkedServiceSnapshots, List<Object> nonChunkedServiceOps, ILogger logger) {
        for (Map.Entry<?, ?> entry : snapshotPerServiceInfo.entrySet()) {
            ServiceInfo serviceInfo = (ServiceInfo)entry.getKey();
            Object serviceSnapshot = entry.getValue();
            if (serviceInfo.getService() instanceof ChunkedSnapshotAwareService) {
                ChunkUtil.processChunkedService(raftIntegration, serviceInfo, (Iterator)serviceSnapshot, commitIndex, chunkedServiceSnapshots, logger);
                continue;
            }
            ChunkUtil.processNonChunkedService(raftIntegration, serviceInfo, serviceSnapshot, commitIndex, nonChunkedServiceOps, logger);
        }
    }

    private static void processChunkedService(RaftIntegration raftIntegration, ServiceInfo serviceInfo, Iterator<DataChunkGroup<?>> iterator, long commitIndex, List<SnapshotChunk> chunkedServiceSnapshots, ILogger logger) {
        int createdChunkCount = 0;
        while (iterator.hasNext()) {
            DataChunkGroup<?> dataChunk = iterator.next();
            Object operation = raftIntegration.newRestoreSnapshotOp(serviceInfo.getName(), commitIndex, dataChunk);
            chunkedServiceSnapshots.add(ChunkUtil.createSnapshotChunkAndSetOperation(operation));
            ++createdChunkCount;
        }
        logger.fine("Snapshot creation for chunked service '%s': created %d chunks at commitIndex=%d", serviceInfo.getName(), createdChunkCount, commitIndex);
    }

    private static void processNonChunkedService(RaftIntegration raftIntegration, ServiceInfo serviceInfo, Object serviceSnapshot, long commitIndex, List<Object> notChunkedServiceOps, ILogger logger) {
        Object operation = raftIntegration.newRestoreSnapshotOp(serviceInfo.getName(), commitIndex, serviceSnapshot);
        notChunkedServiceOps.add(operation);
        logger.fine("Snapshot creation for non-chunked service '%s': 1 operation created at commitIndex=%d", serviceInfo.getName(), commitIndex);
    }

    private static void optimizeChunks(List<SnapshotChunk> chunkedServiceSnapshots, List<Object> notChunkedServiceOps) {
        if (notChunkedServiceOps.isEmpty()) {
            return;
        }
        if (chunkedServiceSnapshots.isEmpty()) {
            chunkedServiceSnapshots.add(ChunkUtil.createSnapshotChunkAndSetOperation(notChunkedServiceOps));
            return;
        }
        SnapshotChunk lastChunk = chunkedServiceSnapshots.get(chunkedServiceSnapshots.size() - 1);
        List existingSnapshotOps = (List)lastChunk.operation();
        existingSnapshotOps.addAll(notChunkedServiceOps);
    }

    private static List<SnapshotChunk> finalizeChunks(List<SnapshotChunk> chunkedServiceSnapshots, int snapshotTerm, long commitIndex, Collection<RaftEndpoint> members, long membersIndex) {
        int chunkCount = chunkedServiceSnapshots.size();
        ArrayList<SnapshotChunk> finalChunks = new ArrayList<SnapshotChunk>(chunkCount);
        for (int chunkNumber = 0; chunkNumber < chunkCount; ++chunkNumber) {
            SnapshotChunk chunk = chunkedServiceSnapshots.get(chunkNumber);
            chunk.setChunkCount(chunkCount).setChunkNumber(chunkNumber).setGroupMembers(members).setGroupMembersLogIndex(membersIndex).setSnapshotTerm(snapshotTerm).setIndex(commitIndex);
            finalChunks.add(chunk);
        }
        return finalChunks;
    }

    private static SnapshotChunk createSnapshotChunkAndSetOperation(Object object) {
        SnapshotChunk chunk = new SnapshotChunk();
        if (object instanceof List) {
            chunk.setOperation(object);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(object);
            chunk.setOperation(list);
        }
        return chunk;
    }

    public static List<SnapshotChunk> extractChunksFrom(@Nonnull SnapshotEntry snapshotEntry) {
        return (List)snapshotEntry.operation();
    }

    public static long getMaxChunkSizeInBytes(HazelcastProperties properties) {
        return MemoryUnit.MEGABYTES.toBytes(properties.getLong(MAX_CHUNK_SIZE_IN_MB));
    }

    public static <T extends AbstractDataChunk> List<DataChunkGroup<T>> groupServiceChunksBySize(@Nonnull List<T> dataChunks, long maxChunkSizeInBytes) {
        ArrayList<DataChunkGroup<T>> groupedChunks = new ArrayList<DataChunkGroup<T>>();
        DataChunkGroup<AbstractDataChunk> currentGroup = new DataChunkGroup<AbstractDataChunk>();
        long currentGroupSize = 0L;
        dataChunks.sort(Comparator.comparingLong(AbstractDataChunk::getChunkSizeInBytes).reversed());
        for (AbstractDataChunk chunk : dataChunks) {
            long chunkSize = ChunkUtil.getChunkSize(chunk);
            if (chunkSize >= maxChunkSizeInBytes) {
                if (!currentGroup.isEmpty()) {
                    groupedChunks.add(currentGroup);
                    currentGroup = new DataChunkGroup();
                    currentGroupSize = 0L;
                }
                currentGroup.add(chunk);
                groupedChunks.add(currentGroup);
                currentGroup = new DataChunkGroup();
                continue;
            }
            if (currentGroupSize + chunkSize <= maxChunkSizeInBytes) {
                currentGroup.add(chunk);
                currentGroupSize += chunkSize;
                continue;
            }
            groupedChunks.add(currentGroup);
            currentGroup = new DataChunkGroup();
            currentGroup.add(chunk);
            currentGroupSize = chunkSize;
        }
        if (!currentGroup.isEmpty()) {
            groupedChunks.add(currentGroup);
        }
        return groupedChunks;
    }

    private static long getChunkSize(Object chunk) {
        if (chunk instanceof KeyValueDataChunk) {
            return ((KeyValueDataChunk)chunk).getChunkSizeInBytes();
        }
        if (chunk instanceof ValueDataChunk) {
            return ((ValueDataChunk)chunk).getChunkSizeInBytes();
        }
        throw new IllegalArgumentException("Unknown chunk object type " + String.valueOf(chunk));
    }

    public static SnapshotEntry toChunkedV60SnapshotFromV55(RaftIntegration raftIntegration, SnapshotEntry snapshotEntry, ILogger logger) {
        if (ListTypeUtils.firstElementIsInstanceOf((List)snapshotEntry.operation(), SnapshotChunk.class)) {
            return snapshotEntry;
        }
        Object serviceSnapshots = raftIntegration.toUnchunkedV60SnapshotFromV55(snapshotEntry.operation());
        List<SnapshotChunk> snapshotChunks = ChunkUtil.createChunksFromSnapshot(raftIntegration, snapshotEntry.term(), snapshotEntry.index(), snapshotEntry.groupMembers(), snapshotEntry.groupMembersLogIndex(), serviceSnapshots, logger);
        snapshotEntry.setOperation(snapshotChunks);
        return snapshotEntry;
    }

    public static SnapshotEntry toV55SnapshotFromChunkedV60(@Nonnull SnapshotEntry snapshotEntry) {
        Objects.requireNonNull(snapshotEntry, "SnapshotEntry cannot be null");
        Object operation = snapshotEntry.operation();
        if (!(operation instanceof List) || !ListTypeUtils.firstElementIsInstanceOf((List)operation, SnapshotChunk.class)) {
            return snapshotEntry;
        }
        ArrayList<RestoreSnapshotOp> snapshotOps = new ArrayList<RestoreSnapshotOp>();
        HashMap<String, Object> serviceSnapshots = new HashMap<String, Object>();
        List<SnapshotChunk> snapshotChunks = ChunkUtil.extractChunksFrom(snapshotEntry);
        for (SnapshotChunk chunk : snapshotChunks) {
            ChunkUtil.processChunk(chunk, serviceSnapshots, snapshotOps);
        }
        serviceSnapshots.forEach((serviceName, snapshot) -> snapshotOps.add(new RestoreSnapshotOp((String)serviceName, snapshot)));
        snapshotEntry.setOperation(snapshotOps);
        return snapshotEntry;
    }

    private static void processChunk(SnapshotChunk chunk, Map<String, Object> serviceSnapshots, List<RestoreSnapshotOp> snapshotOps) {
        Object op = chunk.operation();
        if (!(op instanceof List)) {
            return;
        }
        block8: for (RestoreSnapshotOp restoreOp : (List)op) {
            String serviceName = restoreOp.getServiceName();
            Object snapshotData = restoreOp.getSnapshot();
            switch (serviceName) {
                case "hz:raft:mapService": {
                    ChunkUtil.handleCPMapSnapshot(serviceSnapshots, snapshotData);
                    continue block8;
                }
                case "hz:raft:atomicRefService": {
                    ChunkUtil.handleAtomicRefSnapshot(serviceSnapshots, snapshotData);
                    continue block8;
                }
            }
            snapshotOps.add(restoreOp);
        }
    }

    private static void handleCPMapSnapshot(Map<String, Object> serviceSnapshots, Object snapshotData) {
        if (!(snapshotData instanceof DataChunkGroup)) {
            return;
        }
        DataChunkGroup dataChunkGroup = (DataChunkGroup)snapshotData;
        CPMapRegistrySnapshot cpMapSnapshot = (CPMapRegistrySnapshot)serviceSnapshots.computeIfAbsent("hz:raft:mapService", s -> new CPMapRegistrySnapshot());
        cpMapSnapshot.fromChunks(dataChunkGroup.getServiceData());
    }

    private static void handleAtomicRefSnapshot(Map<String, Object> serviceSnapshots, Object snapshotData) {
        if (!(snapshotData instanceof DataChunkGroup)) {
            return;
        }
        DataChunkGroup dataChunkGroup = (DataChunkGroup)snapshotData;
        AtomicRefSnapshot atomicRefSnapshot = (AtomicRefSnapshot)serviceSnapshots.computeIfAbsent("hz:raft:atomicRefService", s -> new AtomicRefSnapshot());
        atomicRefSnapshot.fromChunks(dataChunkGroup.getServiceData());
    }
}

