/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.semaphore.proxy;

import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftInvocationManager;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.exception.WaitKeyCancelledException;
import com.hazelcast.cp.internal.datastructures.semaphore.operation.AcquirePermitsOp;
import com.hazelcast.cp.internal.datastructures.semaphore.operation.AvailablePermitsOp;
import com.hazelcast.cp.internal.datastructures.semaphore.operation.ChangePermitsOp;
import com.hazelcast.cp.internal.datastructures.semaphore.operation.DrainPermitsOp;
import com.hazelcast.cp.internal.datastructures.semaphore.operation.InitSemaphoreOp;
import com.hazelcast.cp.internal.datastructures.semaphore.operation.ReleasePermitsOp;
import com.hazelcast.cp.internal.datastructures.spi.operation.DestroyRaftObjectOp;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.cp.internal.session.ProxySessionManager;
import com.hazelcast.cp.internal.session.SessionAwareProxy;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.concurrent.TimeUnit;

public class SessionlessSemaphoreProxy
extends SessionAwareProxy
implements ISemaphore {
    private final RaftInvocationManager invocationManager;
    private final String proxyName;
    private final String objectName;

    public SessionlessSemaphoreProxy(NodeEngine nodeEngine, RaftGroupId groupId, String proxyName, String objectName) {
        super((ProxySessionManager)nodeEngine.getService("hz:raft:proxySessionManagerService"), groupId);
        RaftService service = (RaftService)nodeEngine.getService("hz:core:raft");
        this.invocationManager = service.getInvocationManager();
        this.proxyName = proxyName;
        this.objectName = objectName;
    }

    @Override
    public boolean init(int permits) {
        Preconditions.checkNotNegative(permits, "Permits must be non-negative!");
        return (Boolean)this.invocationManager.invoke(this.groupId, new InitSemaphoreOp(this.objectName, permits)).joinInternal();
    }

    @Override
    public void acquire() {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) {
        Preconditions.checkPositive(permits, "Permits must be positive!");
        long clusterWideThreadId = this.getOrCreateUniqueThreadId();
        AcquirePermitsOp op = new AcquirePermitsOp(this.objectName, -1L, clusterWideThreadId, UuidUtil.newUnsecureUUID(), permits, -1L);
        try {
            this.invocationManager.invoke(this.groupId, op).joinInternal();
        }
        catch (WaitKeyCancelledException e) {
            throw new IllegalStateException("Semaphore[" + this.objectName + "] not acquired because the acquire call on the CP group is cancelled, possibly because of another indeterminate call from the same thread.");
        }
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.tryAcquire(permits, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.tryAcquire(1, timeout, unit);
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        Preconditions.checkPositive("permits", permits);
        long clusterWideThreadId = this.getOrCreateUniqueThreadId();
        long timeoutMs = Math.max(0L, unit.toMillis(timeout));
        AcquirePermitsOp op = new AcquirePermitsOp(this.objectName, -1L, clusterWideThreadId, UuidUtil.newUnsecureUUID(), permits, timeoutMs);
        try {
            return (Boolean)this.invocationManager.invoke(this.groupId, op).joinInternal();
        }
        catch (WaitKeyCancelledException e) {
            throw new IllegalStateException("Semaphore[" + this.objectName + "] not acquired because the acquire call on the CP group is cancelled, possibly because of another indeterminate call from the same thread.");
        }
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        Preconditions.checkPositive(permits, "Permits must be positive!");
        long clusterWideThreadId = this.getOrCreateUniqueThreadId();
        ReleasePermitsOp op = new ReleasePermitsOp(this.objectName, -1L, clusterWideThreadId, UuidUtil.newUnsecureUUID(), permits);
        this.invocationManager.invoke(this.groupId, op).joinInternal();
    }

    @Override
    public int availablePermits() {
        return (Integer)this.invocationManager.query(this.groupId, new AvailablePermitsOp(this.objectName), QueryPolicy.LINEARIZABLE).joinInternal();
    }

    @Override
    public int drainPermits() {
        long clusterWideThreadId = this.getOrCreateUniqueThreadId();
        DrainPermitsOp op = new DrainPermitsOp(this.objectName, -1L, clusterWideThreadId, UuidUtil.newUnsecureUUID());
        return (Integer)this.invocationManager.invoke(this.groupId, op).joinInternal();
    }

    @Override
    public void reducePermits(int reduction) {
        Preconditions.checkNotNegative(reduction, "Reduction must be non-negative!");
        if (reduction == 0) {
            return;
        }
        long clusterWideThreadId = this.getOrCreateUniqueThreadId();
        ChangePermitsOp op = new ChangePermitsOp(this.objectName, -1L, clusterWideThreadId, UuidUtil.newUnsecureUUID(), -reduction);
        this.invocationManager.invoke(this.groupId, op).joinInternal();
    }

    @Override
    public void increasePermits(int increase) {
        Preconditions.checkNotNegative(increase, "Increase must be non-negative!");
        if (increase == 0) {
            return;
        }
        long clusterWideThreadId = this.getOrCreateUniqueThreadId();
        ChangePermitsOp op = new ChangePermitsOp(this.objectName, -1L, clusterWideThreadId, UuidUtil.newUnsecureUUID(), increase);
        this.invocationManager.invoke(this.groupId, op).joinInternal();
    }

    @Override
    public String getName() {
        return this.proxyName;
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:raft:semaphoreService";
    }

    @Override
    public void destroy() {
        this.invocationManager.invoke(this.groupId, new DestroyRaftObjectOp(this.getServiceName(), this.objectName)).joinInternal();
    }
}

