/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap;

import com.hazelcast.cp.internal.datastructures.cpmap.CPMapDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapRegistry;
import com.hazelcast.cp.internal.datastructures.cpmap.store.CPMapStore;
import com.hazelcast.cp.internal.datastructures.cpmap.store.HeapCPMapStore;
import com.hazelcast.cp.internal.datastructures.snapshot.KeyValueDataChunk;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class CPMapRegistrySnapshot
implements IdentifiedDataSerializable {
    private Map<String, CPMapStore> mapStores = new HashMap<String, CPMapStore>();
    private Set<String> destroyed = new HashSet<String>();

    public CPMapRegistrySnapshot() {
    }

    public CPMapRegistrySnapshot(CPMapRegistry cpMapRegistry) {
        this.mapStores.putAll(cpMapRegistry.getMapStores());
        this.destroyed.addAll(cpMapRegistry.getDestroyed());
    }

    public boolean isEmpty() {
        return this.mapStores.isEmpty() && this.destroyed.isEmpty();
    }

    public Map<String, CPMapStore> getMapStores() {
        return this.mapStores;
    }

    public Set<String> getDestroyed() {
        return this.destroyed;
    }

    @Nonnull
    public List<KeyValueDataChunk> toChunks(long maxChunkSizeInBytes) {
        ArrayList<KeyValueDataChunk> chunks = new ArrayList<KeyValueDataChunk>();
        for (Map.Entry<String, CPMapStore> storeEntry : this.mapStores.entrySet()) {
            String mapName = storeEntry.getKey();
            CPMapStore mapStore = storeEntry.getValue();
            if (mapStore.size() == 0) continue;
            KeyValueDataChunk currentChunk = new KeyValueDataChunk(mapName);
            chunks.add(currentChunk);
            Iterator<Map.Entry<Data, Data>> iterator = mapStore.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Data, Data> entry = iterator.next();
                if (currentChunk.getChunkSizeInBytes() >= maxChunkSizeInBytes) {
                    currentChunk = new KeyValueDataChunk(mapName);
                    chunks.add(currentChunk);
                }
                currentChunk.addToChunk(entry.getKey(), entry.getValue());
            }
        }
        for (String destroyedName : this.destroyed) {
            chunks.add(new KeyValueDataChunk(destroyedName, true));
        }
        return chunks;
    }

    public void fromChunks(List<KeyValueDataChunk> chunks) {
        for (KeyValueDataChunk chunk : chunks) {
            String mapName = chunk.getName();
            if (chunk.isDestroyed()) {
                this.destroyed.add(mapName);
                continue;
            }
            CPMapStore store = this.mapStores.computeIfAbsent(mapName, k -> new HeapCPMapStore(2000));
            List<Data> keyValuePairs = chunk.getKeyValuePairs();
            for (int i = 0; i < keyValuePairs.size(); i += 2) {
                Data key = keyValuePairs.get(i);
                Data value = keyValuePairs.get(i + 1);
                store.put(key, value);
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.mapStores.size());
        for (Map.Entry<String, CPMapStore> map : this.mapStores.entrySet()) {
            out.writeString(map.getKey());
            out.writeObject(map.getValue());
        }
        out.writeInt(this.destroyed.size());
        for (String name : this.destroyed) {
            out.writeString(name);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int mapsCount = in.readInt();
        this.mapStores = new HashMap<String, CPMapStore>(mapsCount);
        for (int i = 0; i < mapsCount; ++i) {
            String mapName = in.readString();
            CPMapStore cpMapStore = (CPMapStore)in.readObject();
            this.mapStores.put(mapName, cpMapStore);
        }
        int count = in.readInt();
        this.destroyed = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            String name = in.readString();
            this.destroyed.add(name);
        }
    }

    @Override
    public int getFactoryId() {
        return CPMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    public String toString() {
        return "CPMapRegistrySnapshot{mapStores=" + String.valueOf(this.mapStores) + ", destroyed=" + String.valueOf(this.destroyed) + "}";
    }
}

