/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.cpmap;

import com.hazelcast.config.cp.CPMapConfig;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapRegistrySnapshot;
import com.hazelcast.cp.internal.datastructures.cpmap.store.CPMapStore;
import com.hazelcast.cp.internal.datastructures.cpmap.store.HeapCPMapStore;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CPMapRegistry {
    public static final int DEFAULT_MAP_MAX_SIZE_MB = 100;
    private final String groupName;
    private final Map<String, CPMapStore> mapStores;
    private final Set<String> destroyed;

    public CPMapRegistry(CPGroupId groupId) {
        this.groupName = groupId.getName();
        this.mapStores = new ConcurrentHashMap<String, CPMapStore>();
        this.destroyed = ConcurrentHashMap.newKeySet();
    }

    public CPMapStore getMapStore(String mapName, CPSubsystemConfig cpSubsystemConfig) {
        if (this.destroyed.contains(mapName)) {
            throw new DistributedObjectDestroyedException("CPMap[" + mapName + "@" + this.groupName + "] is already destroyed!");
        }
        return this.mapStores.computeIfAbsent(mapName, k -> new HeapCPMapStore(CPMapRegistry.getMapMaxSizeMb(cpSubsystemConfig, mapName)));
    }

    public boolean destroyMapStore(String mapName) {
        this.destroyed.add(mapName);
        return this.mapStores.remove(mapName) != null;
    }

    public void collectMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        for (Map.Entry<String, CPMapStore> e : this.mapStores.entrySet()) {
            String mapName = e.getKey();
            MetricDescriptor mapDescriptorRoot = descriptor.copy().withDiscriminator("id", mapName + "@" + this.groupName).withTag("name", mapName).withTag("group", this.groupName);
            e.getValue().collectMetrics(mapDescriptorRoot, context);
        }
    }

    static int getMapMaxSizeMb(CPSubsystemConfig cpSubsystemConfig, String objectName) {
        CPMapConfig mapConfig = cpSubsystemConfig.findCPMapConfig(objectName);
        if (mapConfig != null) {
            return mapConfig.getMaxSizeMb();
        }
        return 100;
    }

    String getGroupName() {
        return this.groupName;
    }

    Set<String> getDestroyed() {
        return this.destroyed;
    }

    Map<String, CPMapStore> getMapStores() {
        return this.mapStores;
    }

    public void resetForChunkedSnapshotRestore() {
        this.mapStores.clear();
        this.destroyed.clear();
    }

    public CPMapRegistrySnapshot takeSnapshot() {
        return new CPMapRegistrySnapshot(this);
    }

    public void v55restoreCPMapRegistrySnapshot(CPMapRegistrySnapshot snapshot) {
        this.mapStores.clear();
        this.mapStores.putAll(snapshot.getMapStores());
        this.destroyed.clear();
        this.destroyed.addAll(snapshot.getDestroyed());
    }
}

