/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.atomicref;

import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRefDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.snapshot.AbstractDataChunk;
import com.hazelcast.cp.internal.datastructures.snapshot.ValueDataChunk;
import com.hazelcast.cp.internal.datastructures.spi.atomic.RaftAtomicValueSnapshot;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class AtomicRefSnapshot
extends RaftAtomicValueSnapshot<Data>
implements IdentifiedDataSerializable {
    public AtomicRefSnapshot() {
    }

    public AtomicRefSnapshot(Map<String, Data> refs, Set<String> destroyed) {
        super(refs, destroyed);
    }

    @Nonnull
    public List<ValueDataChunk> toChunks() {
        ArrayList<ValueDataChunk> valueDataChunks = new ArrayList<ValueDataChunk>();
        for (Map.Entry entry : this.getValues()) {
            String name = entry.getKey();
            Data value = (Data)entry.getValue();
            valueDataChunks.add(new ValueDataChunk(name, value));
        }
        for (String destroyedName : this.destroyed) {
            valueDataChunks.add(new ValueDataChunk(destroyedName, true));
        }
        valueDataChunks.sort(Comparator.comparing(AbstractDataChunk::isDestroyed).thenComparing(AbstractDataChunk::getName));
        return valueDataChunks;
    }

    public void fromChunks(List<ValueDataChunk> chunks) {
        for (ValueDataChunk chunk : chunks) {
            String mapName = chunk.getName();
            if (chunk.isDestroyed()) {
                this.destroyed.add(mapName);
                continue;
            }
            String name = chunk.getName();
            Data value = chunk.getValue();
            this.values.put(name, value);
        }
    }

    @Override
    public int getFactoryId() {
        return AtomicRefDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeValue(ObjectDataOutput out, Data value) throws IOException {
        IOUtil.writeData(out, value);
    }

    @Override
    protected Data readValue(ObjectDataInput in) throws IOException {
        return IOUtil.readData(in);
    }

    public String toString() {
        return "AtomicRefSnapshot{refs=" + String.valueOf(this.values) + ", destroyed=" + String.valueOf(this.destroyed) + "}";
    }
}

